/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when new or updated holdings have been detected on an investment account. The webhook typically fires in response to any newly added holdings or price changes to existing holdings, most commonly after market close.")
public class HoldingsDefaultUpdateWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_NEW_HOLDINGS = "new_holdings";
    @SerializedName(value="new_holdings")
    private Double newHoldings;
    public static final String SERIALIZED_NAME_UPDATED_HOLDINGS = "updated_holdings";
    @SerializedName(value="updated_holdings")
    private Double updatedHoldings;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public HoldingsDefaultUpdateWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`HOLDINGS`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public HoldingsDefaultUpdateWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`DEFAULT_UPDATE`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public HoldingsDefaultUpdateWebhook itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public HoldingsDefaultUpdateWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public HoldingsDefaultUpdateWebhook newHoldings(Double newHoldings) {
        this.newHoldings = newHoldings;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of new holdings reported since the last time this webhook was fired.")
    public Double getNewHoldings() {
        return this.newHoldings;
    }

    public void setNewHoldings(Double newHoldings) {
        this.newHoldings = newHoldings;
    }

    public HoldingsDefaultUpdateWebhook updatedHoldings(Double updatedHoldings) {
        this.updatedHoldings = updatedHoldings;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of updated holdings reported since the last time this webhook was fired.")
    public Double getUpdatedHoldings() {
        return this.updatedHoldings;
    }

    public void setUpdatedHoldings(Double updatedHoldings) {
        this.updatedHoldings = updatedHoldings;
    }

    public HoldingsDefaultUpdateWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoldingsDefaultUpdateWebhook holdingsDefaultUpdateWebhook = (HoldingsDefaultUpdateWebhook)o;
        return Objects.equals(this.webhookType, holdingsDefaultUpdateWebhook.webhookType) && Objects.equals(this.webhookCode, holdingsDefaultUpdateWebhook.webhookCode) && Objects.equals(this.itemId, holdingsDefaultUpdateWebhook.itemId) && Objects.equals(this.error, holdingsDefaultUpdateWebhook.error) && Objects.equals(this.newHoldings, holdingsDefaultUpdateWebhook.newHoldings) && Objects.equals(this.updatedHoldings, holdingsDefaultUpdateWebhook.updatedHoldings) && Objects.equals((Object)this.environment, (Object)holdingsDefaultUpdateWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.itemId, this.error, this.newHoldings, this.updatedHoldings, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HoldingsDefaultUpdateWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    newHoldings: ").append(this.toIndentedString(this.newHoldings)).append("\n");
        sb.append("    updatedHoldings: ").append(this.toIndentedString(this.updatedHoldings)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

