/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SecurityOverride;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specify the holdings on the account.")
public class HoldingsOverride {
    public static final String SERIALIZED_NAME_INSTITUTION_PRICE = "institution_price";
    @SerializedName(value="institution_price")
    private Double institutionPrice;
    public static final String SERIALIZED_NAME_INSTITUTION_PRICE_AS_OF = "institution_price_as_of";
    @SerializedName(value="institution_price_as_of")
    private LocalDate institutionPriceAsOf;
    public static final String SERIALIZED_NAME_COST_BASIS = "cost_basis";
    @SerializedName(value="cost_basis")
    private Double costBasis;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Double quantity;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_SECURITY = "security";
    @SerializedName(value="security")
    private SecurityOverride security;

    public HoldingsOverride institutionPrice(Double institutionPrice) {
        this.institutionPrice = institutionPrice;
        return this;
    }

    @ApiModelProperty(required=true, value="The last price given by the institution for this security")
    public Double getInstitutionPrice() {
        return this.institutionPrice;
    }

    public void setInstitutionPrice(Double institutionPrice) {
        this.institutionPrice = institutionPrice;
    }

    public HoldingsOverride institutionPriceAsOf(LocalDate institutionPriceAsOf) {
        this.institutionPriceAsOf = institutionPriceAsOf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date at which `institution_price` was current. Must be formatted as an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) date.")
    public LocalDate getInstitutionPriceAsOf() {
        return this.institutionPriceAsOf;
    }

    public void setInstitutionPriceAsOf(LocalDate institutionPriceAsOf) {
        this.institutionPriceAsOf = institutionPriceAsOf;
    }

    public HoldingsOverride costBasis(Double costBasis) {
        this.costBasis = costBasis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total cost basis of the holding (e.g., the total amount spent to acquire all assets currently in the holding).")
    public Double getCostBasis() {
        return this.costBasis;
    }

    public void setCostBasis(Double costBasis) {
        this.costBasis = costBasis;
    }

    public HoldingsOverride quantity(Double quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The total quantity of the asset held, as reported by the financial institution.")
    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public HoldingsOverride currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="Either a valid `iso_currency_code` or `unofficial_currency_code`")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public HoldingsOverride security(SecurityOverride security) {
        this.security = security;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SecurityOverride getSecurity() {
        return this.security;
    }

    public void setSecurity(SecurityOverride security) {
        this.security = security;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoldingsOverride holdingsOverride = (HoldingsOverride)o;
        return Objects.equals(this.institutionPrice, holdingsOverride.institutionPrice) && Objects.equals(this.institutionPriceAsOf, holdingsOverride.institutionPriceAsOf) && Objects.equals(this.costBasis, holdingsOverride.costBasis) && Objects.equals(this.quantity, holdingsOverride.quantity) && Objects.equals(this.currency, holdingsOverride.currency) && Objects.equals(this.security, holdingsOverride.security);
    }

    public int hashCode() {
        return Objects.hash(this.institutionPrice, this.institutionPriceAsOf, this.costBasis, this.quantity, this.currency, this.security);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HoldingsOverride {\n");
        sb.append("    institutionPrice: ").append(this.toIndentedString(this.institutionPrice)).append("\n");
        sb.append("    institutionPriceAsOf: ").append(this.toIndentedString(this.institutionPriceAsOf)).append("\n");
        sb.append("    costBasis: ").append(this.toIndentedString(this.costBasis)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    security: ").append(this.toIndentedString(this.security)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

