/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityUpdateTypes;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when a change to identity data has been detected on an Item. Items are checked for identity updates every 30-90 days. We recommend that upon receiving this webhook you make another call to `/identity/get` to fetch the user's latest identity data.")
public class IdentityDefaultUpdateWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_ACCOUNT_IDS_WITH_UPDATED_IDENTITY = "account_ids_with_updated_identity";
    @SerializedName(value="account_ids_with_updated_identity")
    private Map<String, List<IdentityUpdateTypes>> accountIdsWithUpdatedIdentity = new HashMap<String, List<IdentityUpdateTypes>>();
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public IdentityDefaultUpdateWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`IDENTITY`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public IdentityDefaultUpdateWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`DEFAULT_UPDATE`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public IdentityDefaultUpdateWebhook itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public IdentityDefaultUpdateWebhook accountIdsWithUpdatedIdentity(Map<String, List<IdentityUpdateTypes>> accountIdsWithUpdatedIdentity) {
        this.accountIdsWithUpdatedIdentity = accountIdsWithUpdatedIdentity;
        return this;
    }

    public IdentityDefaultUpdateWebhook putAccountIdsWithUpdatedIdentityItem(String key, List<IdentityUpdateTypes> accountIdsWithUpdatedIdentityItem) {
        this.accountIdsWithUpdatedIdentity.put(key, accountIdsWithUpdatedIdentityItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An object with keys of `account_id`'s that are mapped to their respective identity attributes that changed.  Example: `{ \"XMBvvyMGQ1UoLbKByoMqH3nXMj84ALSdE5B58\": [\"PHONES\"] }` ")
    public Map<String, List<IdentityUpdateTypes>> getAccountIdsWithUpdatedIdentity() {
        return this.accountIdsWithUpdatedIdentity;
    }

    public void setAccountIdsWithUpdatedIdentity(Map<String, List<IdentityUpdateTypes>> accountIdsWithUpdatedIdentity) {
        this.accountIdsWithUpdatedIdentity = accountIdsWithUpdatedIdentity;
    }

    public IdentityDefaultUpdateWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public IdentityDefaultUpdateWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityDefaultUpdateWebhook identityDefaultUpdateWebhook = (IdentityDefaultUpdateWebhook)o;
        return Objects.equals(this.webhookType, identityDefaultUpdateWebhook.webhookType) && Objects.equals(this.webhookCode, identityDefaultUpdateWebhook.webhookCode) && Objects.equals(this.itemId, identityDefaultUpdateWebhook.itemId) && Objects.equals(this.accountIdsWithUpdatedIdentity, identityDefaultUpdateWebhook.accountIdsWithUpdatedIdentity) && Objects.equals(this.error, identityDefaultUpdateWebhook.error) && Objects.equals((Object)this.environment, (Object)identityDefaultUpdateWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.itemId, this.accountIdsWithUpdatedIdentity, this.error, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityDefaultUpdateWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    accountIdsWithUpdatedIdentity: ").append(this.toIndentedString(this.accountIdsWithUpdatedIdentity)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

