/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="In closed beta. Object representing metadata pertaining to the document.")
public class IdentityDocumentUploadMetadata {
    public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
    @SerializedName(value="document_type")
    private String documentType;
    public static final String SERIALIZED_NAME_IS_ACCOUNT_NUMBER_MATCH = "is_account_number_match";
    @SerializedName(value="is_account_number_match")
    private Boolean isAccountNumberMatch;
    public static final String SERIALIZED_NAME_PAGE_COUNT = "page_count";
    @SerializedName(value="page_count")
    private Integer pageCount;
    public static final String SERIALIZED_NAME_LAST_UPDATED = "last_updated";
    @SerializedName(value="last_updated")
    private OffsetDateTime lastUpdated;
    public static final String SERIALIZED_NAME_UPLOADED_AT = "uploaded_at";
    @SerializedName(value="uploaded_at")
    private OffsetDateTime uploadedAt;

    public IdentityDocumentUploadMetadata documentType(String documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="String enumeration of the submitted document type.")
    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public IdentityDocumentUploadMetadata isAccountNumberMatch(Boolean isAccountNumberMatch) {
        this.isAccountNumberMatch = isAccountNumberMatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean field indicating if the uploaded document's account number matches the account number we have on file")
    public Boolean getIsAccountNumberMatch() {
        return this.isAccountNumberMatch;
    }

    public void setIsAccountNumberMatch(Boolean isAccountNumberMatch) {
        this.isAccountNumberMatch = isAccountNumberMatch;
    }

    public IdentityDocumentUploadMetadata pageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public IdentityDocumentUploadMetadata lastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public IdentityDocumentUploadMetadata uploadedAt(OffsetDateTime uploadedAt) {
        this.uploadedAt = uploadedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getUploadedAt() {
        return this.uploadedAt;
    }

    public void setUploadedAt(OffsetDateTime uploadedAt) {
        this.uploadedAt = uploadedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityDocumentUploadMetadata identityDocumentUploadMetadata = (IdentityDocumentUploadMetadata)o;
        return Objects.equals(this.documentType, identityDocumentUploadMetadata.documentType) && Objects.equals(this.isAccountNumberMatch, identityDocumentUploadMetadata.isAccountNumberMatch) && Objects.equals(this.pageCount, identityDocumentUploadMetadata.pageCount) && Objects.equals(this.lastUpdated, identityDocumentUploadMetadata.lastUpdated) && Objects.equals(this.uploadedAt, identityDocumentUploadMetadata.uploadedAt);
    }

    public int hashCode() {
        return Objects.hash(this.documentType, this.isAccountNumberMatch, this.pageCount, this.lastUpdated, this.uploadedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityDocumentUploadMetadata {\n");
        sb.append("    documentType: ").append(this.toIndentedString(this.documentType)).append("\n");
        sb.append("    isAccountNumberMatch: ").append(this.toIndentedString(this.isAccountNumberMatch)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    uploadedAt: ").append(this.toIndentedString(this.uploadedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

