/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountIdentity;
import com.plaid.client.model.Item;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="IdentityGetResponse defines the response schema for `/identity/get`")
public class IdentityGetResponse {
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountIdentity> accounts = new ArrayList<AccountIdentity>();
    public static final String SERIALIZED_NAME_ITEM = "item";
    @SerializedName(value="item")
    private Item item;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public IdentityGetResponse accounts(List<AccountIdentity> accounts) {
        this.accounts = accounts;
        return this;
    }

    public IdentityGetResponse addAccountsItem(AccountIdentity accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The accounts for which Identity data has been requested")
    public List<AccountIdentity> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountIdentity> accounts) {
        this.accounts = accounts;
    }

    public IdentityGetResponse item(Item item) {
        this.item = item;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public IdentityGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityGetResponse identityGetResponse = (IdentityGetResponse)o;
        return Objects.equals(this.accounts, identityGetResponse.accounts) && Objects.equals(this.item, identityGetResponse.item) && Objects.equals(this.requestId, identityGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.item, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityGetResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

