/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityMatchRequestOptions;
import com.plaid.client.model.IdentityMatchUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IdentityMatchRequest defines the request schema for `/identity/match`")
public class IdentityMatchRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private IdentityMatchUser user;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private IdentityMatchRequestOptions options;

    public IdentityMatchRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public IdentityMatchRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public IdentityMatchRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public IdentityMatchRequest user(IdentityMatchUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IdentityMatchUser getUser() {
        return this.user;
    }

    public void setUser(IdentityMatchUser user) {
        this.user = user;
    }

    public IdentityMatchRequest options(IdentityMatchRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IdentityMatchRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(IdentityMatchRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityMatchRequest identityMatchRequest = (IdentityMatchRequest)o;
        return Objects.equals(this.clientId, identityMatchRequest.clientId) && Objects.equals(this.secret, identityMatchRequest.secret) && Objects.equals(this.accessToken, identityMatchRequest.accessToken) && Objects.equals(this.user, identityMatchRequest.user) && Objects.equals(this.options, identityMatchRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.accessToken, this.user, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityMatchRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

