/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AddressDataNullableNoRequiredFields;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The user's legal name, phone number, email address and address used to perform fuzzy match. If Financial Account Matching is enabled in the Identity Verification product, leave this field empty to automatically match against PII collected from the Identity Verification checks.")
public class IdentityMatchUser {
    public static final String SERIALIZED_NAME_LEGAL_NAME = "legal_name";
    @SerializedName(value="legal_name")
    private String legalName;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private AddressDataNullableNoRequiredFields address;

    public IdentityMatchUser legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's full legal name.")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public IdentityMatchUser phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's phone number, in E.164 format: +{countrycode}{number}. For example: \"+14151234567\". Phone numbers provided in other formats will be parsed on a best-effort basis.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public IdentityMatchUser emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public IdentityMatchUser address(AddressDataNullableNoRequiredFields address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AddressDataNullableNoRequiredFields getAddress() {
        return this.address;
    }

    public void setAddress(AddressDataNullableNoRequiredFields address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityMatchUser identityMatchUser = (IdentityMatchUser)o;
        return Objects.equals(this.legalName, identityMatchUser.legalName) && Objects.equals(this.phoneNumber, identityMatchUser.phoneNumber) && Objects.equals(this.emailAddress, identityMatchUser.emailAddress) && Objects.equals(this.address, identityMatchUser.address);
    }

    public int hashCode() {
        return Objects.hash(this.legalName, this.phoneNumber, this.emailAddress, this.address);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityMatchUser {\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

