/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AddressPurposeLabel;
import com.plaid.client.model.POBoxStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Even if an address has been autofilled, some fields may be null depending on the region's addressing system. For example:  Addresses from the United Kingdom will not include a region  Addresses from Hong Kong will not include postal code")
public class IdentityVerificationAutofillAddress {
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private String street;
    public static final String SERIALIZED_NAME_STREET2 = "street2";
    @SerializedName(value="street2")
    private String street2;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_PO_BOX = "po_box";
    @SerializedName(value="po_box")
    private POBoxStatus poBox;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private AddressPurposeLabel type;

    public IdentityVerificationAutofillAddress street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(example="123 Main St.", required=true, value="The primary street portion of an address. If an address is provided, this field will always be filled. A string with at least one non-whitespace alphabetical character, with a max length of 80 characters.")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public IdentityVerificationAutofillAddress street2(String street2) {
        this.street2 = street2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Unit 42", required=true, value="Extra street information, like an apartment or suite number. If provided, a string with at least one non-whitespace character, with a max length of 20 characters.")
    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public IdentityVerificationAutofillAddress city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Pawnee", required=true, value="City from the end user's address. A string with at least one non-whitespace alphabetical character, with a max length of 100 characters.\"")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public IdentityVerificationAutofillAddress region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IN", required=true, value="An ISO 3166-2 subdivision code. Related terms would be \"state\", \"province\", \"prefecture\", \"zone\", \"subdivision\", etc.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public IdentityVerificationAutofillAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="46001", required=true, value="The postal code for the associated address. Between 2 and 10 alphanumeric characters. For US-based addresses this must be 5 numeric digits.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public IdentityVerificationAutofillAddress country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(example="US", required=true, value="Valid, capitalized, two-letter ISO code representing the country of this object. Must be in ISO 3166-1 alpha-2 form.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public IdentityVerificationAutofillAddress poBox(POBoxStatus poBox) {
        this.poBox = poBox;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public POBoxStatus getPoBox() {
        return this.poBox;
    }

    public void setPoBox(POBoxStatus poBox) {
        this.poBox = poBox;
    }

    public IdentityVerificationAutofillAddress type(AddressPurposeLabel type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AddressPurposeLabel getType() {
        return this.type;
    }

    public void setType(AddressPurposeLabel type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationAutofillAddress identityVerificationAutofillAddress = (IdentityVerificationAutofillAddress)o;
        return Objects.equals(this.street, identityVerificationAutofillAddress.street) && Objects.equals(this.street2, identityVerificationAutofillAddress.street2) && Objects.equals(this.city, identityVerificationAutofillAddress.city) && Objects.equals(this.region, identityVerificationAutofillAddress.region) && Objects.equals(this.postalCode, identityVerificationAutofillAddress.postalCode) && Objects.equals(this.country, identityVerificationAutofillAddress.country) && Objects.equals((Object)this.poBox, (Object)identityVerificationAutofillAddress.poBox) && Objects.equals((Object)this.type, (Object)identityVerificationAutofillAddress.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.street, this.street2, this.city, this.region, this.postalCode, this.country, this.poBox, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationAutofillAddress {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    poBox: ").append(this.toIndentedString((Object)this.poBox)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

