/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityVerificationCreateRequestUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request schema for '/identity_verification/create'")
public class IdentityVerificationCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_IS_SHAREABLE = "is_shareable";
    @SerializedName(value="is_shareable")
    private Boolean isShareable;
    public static final String SERIALIZED_NAME_TEMPLATE_ID = "template_id";
    @SerializedName(value="template_id")
    private String templateId;
    public static final String SERIALIZED_NAME_GAVE_CONSENT = "gave_consent";
    @SerializedName(value="gave_consent")
    private Boolean gaveConsent = false;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private IdentityVerificationCreateRequestUser user;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_IS_IDEMPOTENT = "is_idempotent";
    @SerializedName(value="is_idempotent")
    private Boolean isIdempotent;

    public IdentityVerificationCreateRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-db-id-3b24110", value="A unique ID that identifies the end user in your system. This ID can also be used to associate user-specific data from other Plaid products. Financial Account Matching requires this field and the `/link/token/create` `client_user_id` to be consistent. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public IdentityVerificationCreateRequest isShareable(Boolean isShareable) {
        this.isShareable = isShareable;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="A flag specifying whether you would like Plaid to expose a shareable URL for the verification being created.")
    public Boolean getIsShareable() {
        return this.isShareable;
    }

    public void setIsShareable(Boolean isShareable) {
        this.isShareable = isShareable;
    }

    public IdentityVerificationCreateRequest templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @ApiModelProperty(example="idvtmp_4FrXJvfQU3zGUR", required=true, value="ID of the associated Identity Verification template.")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public IdentityVerificationCreateRequest gaveConsent(Boolean gaveConsent) {
        this.gaveConsent = gaveConsent;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="A flag specifying whether the end user has already agreed to a privacy policy specifying that their data will be shared with Plaid for verification purposes.  If `gave_consent` is set to `true`, the `accept_tos` step will be marked as `skipped` and the end user's session will start at the next step requirement.")
    public Boolean getGaveConsent() {
        return this.gaveConsent;
    }

    public void setGaveConsent(Boolean gaveConsent) {
        this.gaveConsent = gaveConsent;
    }

    public IdentityVerificationCreateRequest user(IdentityVerificationCreateRequestUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IdentityVerificationCreateRequestUser getUser() {
        return this.user;
    }

    public void setUser(IdentityVerificationCreateRequestUser user) {
        this.user = user;
    }

    public IdentityVerificationCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public IdentityVerificationCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public IdentityVerificationCreateRequest isIdempotent(Boolean isIdempotent) {
        this.isIdempotent = isIdempotent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="An optional flag specifying how you would like Plaid to handle attempts to create an Identity Verification when an Identity Verification already exists for the provided `client_user_id` and `template_id`. If idempotency is enabled, Plaid will return the existing Identity Verification. If idempotency is disabled, Plaid will reject the request with a `400 Bad Request` status code if an Identity Verification already exists for the supplied `client_user_id` and `template_id`.")
    public Boolean getIsIdempotent() {
        return this.isIdempotent;
    }

    public void setIsIdempotent(Boolean isIdempotent) {
        this.isIdempotent = isIdempotent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationCreateRequest identityVerificationCreateRequest = (IdentityVerificationCreateRequest)o;
        return Objects.equals(this.clientUserId, identityVerificationCreateRequest.clientUserId) && Objects.equals(this.isShareable, identityVerificationCreateRequest.isShareable) && Objects.equals(this.templateId, identityVerificationCreateRequest.templateId) && Objects.equals(this.gaveConsent, identityVerificationCreateRequest.gaveConsent) && Objects.equals(this.user, identityVerificationCreateRequest.user) && Objects.equals(this.clientId, identityVerificationCreateRequest.clientId) && Objects.equals(this.secret, identityVerificationCreateRequest.secret) && Objects.equals(this.isIdempotent, identityVerificationCreateRequest.isIdempotent);
    }

    public int hashCode() {
        return Objects.hash(this.clientUserId, this.isShareable, this.templateId, this.gaveConsent, this.user, this.clientId, this.secret, this.isIdempotent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationCreateRequest {\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    isShareable: ").append(this.toIndentedString(this.isShareable)).append("\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    gaveConsent: ").append(this.toIndentedString(this.gaveConsent)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    isIdempotent: ").append(this.toIndentedString(this.isIdempotent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

