/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityVerificationRequestUserName;
import com.plaid.client.model.UserAddress;
import com.plaid.client.model.UserIDNumber;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="User information collected outside of Link, most likely via your own onboarding process.  Each of the following identity fields are optional:  `email_address`  `phone_number`  `date_of_birth`  `name`  `address`  `id_number`  Specifically, these fields are optional in that they can either be fully provided (satisfying every required field in their subschema) or omitted from the request entirely by not providing the key or value. Providing these fields via the API will result in Link skipping the data collection process for the associated user. All verification steps enabled in the associated Identity Verification Template will still be run. Verification steps will either be run immediately, or once the user completes the `accept_tos` step, depending on the value provided to the `gave_consent` field. If you are not using the shareable URL feature, you can optionally provide these fields via `/link/token/create` instead; both `/identity_verification/create` and `/link/token/create` are valid ways to provide this information. Note that if you provide a non-`null` user data object via `/identity_verification/create`, any user data fields entered via `/link/token/create` for the same `client_user_id` will be ignored when prefilling Link.")
public class IdentityVerificationCreateRequestUser {
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private IdentityVerificationRequestUserName name;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private UserAddress address;
    public static final String SERIALIZED_NAME_ID_NUMBER = "id_number";
    @SerializedName(value="id_number")
    private UserIDNumber idNumber;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;

    public IdentityVerificationCreateRequestUser emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user@example.com", value="A valid email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public IdentityVerificationCreateRequestUser phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="+19876543212", value="A phone number in E.164 format.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public IdentityVerificationCreateRequestUser dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public IdentityVerificationCreateRequestUser name(IdentityVerificationRequestUserName name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IdentityVerificationRequestUserName getName() {
        return this.name;
    }

    public void setName(IdentityVerificationRequestUserName name) {
        this.name = name;
    }

    public IdentityVerificationCreateRequestUser address(UserAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserAddress getAddress() {
        return this.address;
    }

    public void setAddress(UserAddress address) {
        this.address = address;
    }

    public IdentityVerificationCreateRequestUser idNumber(UserIDNumber idNumber) {
        this.idNumber = idNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserIDNumber getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(UserIDNumber idNumber) {
        this.idNumber = idNumber;
    }

    public IdentityVerificationCreateRequestUser clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-db-id-3b24110", value="Specifying `user.client_user_id` is deprecated. Please provide `client_user_id` at the root level instead.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationCreateRequestUser identityVerificationCreateRequestUser = (IdentityVerificationCreateRequestUser)o;
        return Objects.equals(this.emailAddress, identityVerificationCreateRequestUser.emailAddress) && Objects.equals(this.phoneNumber, identityVerificationCreateRequestUser.phoneNumber) && Objects.equals(this.dateOfBirth, identityVerificationCreateRequestUser.dateOfBirth) && Objects.equals(this.name, identityVerificationCreateRequestUser.name) && Objects.equals(this.address, identityVerificationCreateRequestUser.address) && Objects.equals(this.idNumber, identityVerificationCreateRequestUser.idNumber) && Objects.equals(this.clientUserId, identityVerificationCreateRequestUser.clientUserId);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddress, this.phoneNumber, this.dateOfBirth, this.name, this.address, this.idNumber, this.clientUserId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationCreateRequestUser {\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    idNumber: ").append(this.toIndentedString(this.idNumber)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

