/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DocumentaryVerification;
import com.plaid.client.model.IdentityVerificationStatus;
import com.plaid.client.model.IdentityVerificationStepSummary;
import com.plaid.client.model.IdentityVerificationTemplateReference;
import com.plaid.client.model.IdentityVerificationUserData;
import com.plaid.client.model.KYCCheckDetails;
import com.plaid.client.model.RiskCheckDetails;
import com.plaid.client.model.SelfieCheck;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A identity verification attempt represents a customer's attempt to verify their identity, reflecting the required steps for completing the session, the results for each step, and information collected in the process.")
public class IdentityVerificationCreateResponse {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private Timestamp createdAt;
    public static final String SERIALIZED_NAME_COMPLETED_AT = "completed_at";
    @SerializedName(value="completed_at")
    private OffsetDateTime completedAt;
    public static final String SERIALIZED_NAME_PREVIOUS_ATTEMPT_ID = "previous_attempt_id";
    @SerializedName(value="previous_attempt_id")
    private String previousAttemptId;
    public static final String SERIALIZED_NAME_SHAREABLE_URL = "shareable_url";
    @SerializedName(value="shareable_url")
    private String shareableUrl;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private IdentityVerificationTemplateReference template;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private IdentityVerificationUserData user;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private IdentityVerificationStatus status;
    public static final String SERIALIZED_NAME_STEPS = "steps";
    @SerializedName(value="steps")
    private IdentityVerificationStepSummary steps;
    public static final String SERIALIZED_NAME_DOCUMENTARY_VERIFICATION = "documentary_verification";
    @SerializedName(value="documentary_verification")
    private DocumentaryVerification documentaryVerification;
    public static final String SERIALIZED_NAME_SELFIE_CHECK = "selfie_check";
    @SerializedName(value="selfie_check")
    private SelfieCheck selfieCheck;
    public static final String SERIALIZED_NAME_KYC_CHECK = "kyc_check";
    @SerializedName(value="kyc_check")
    private KYCCheckDetails kycCheck;
    public static final String SERIALIZED_NAME_RISK_CHECK = "risk_check";
    @SerializedName(value="risk_check")
    private RiskCheckDetails riskCheck;
    public static final String SERIALIZED_NAME_WATCHLIST_SCREENING_ID = "watchlist_screening_id";
    @SerializedName(value="watchlist_screening_id")
    private String watchlistScreeningId;
    public static final String SERIALIZED_NAME_REDACTED_AT = "redacted_at";
    @SerializedName(value="redacted_at")
    private OffsetDateTime redactedAt;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public IdentityVerificationCreateResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="idv_52xR9LKo77r1Np", required=true, value="ID of the associated Identity Verification attempt.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IdentityVerificationCreateResponse clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @ApiModelProperty(example="your-db-id-3b24110", required=true, value="A unique ID that identifies the end user in your system. This ID can also be used to associate user-specific data from other Plaid products. Financial Account Matching requires this field and the `/link/token/create` `client_user_id` to be consistent. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public IdentityVerificationCreateResponse createdAt(Timestamp createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public IdentityVerificationCreateResponse completedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-07-24T03:26:02Z", required=true, value="An ISO8601 formatted timestamp.")
    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
    }

    public IdentityVerificationCreateResponse previousAttemptId(String previousAttemptId) {
        this.previousAttemptId = previousAttemptId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="idv_42cF1MNo42r9Xj", required=true, value="The ID for the Identity Verification preceding this session. This field will only be filled if the current Identity Verification is a retry of a previous attempt.")
    public String getPreviousAttemptId() {
        return this.previousAttemptId;
    }

    public void setPreviousAttemptId(String previousAttemptId) {
        this.previousAttemptId = previousAttemptId;
    }

    public IdentityVerificationCreateResponse shareableUrl(String shareableUrl) {
        this.shareableUrl = shareableUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://flow.plaid.com/verify/idv_4FrXJvfQU3zGUR?key=e004115db797f7cc3083bff3167cba30644ef630fb46f5b086cde6cc3b86a36f", required=true, value="A shareable URL that can be sent directly to the user to complete verification")
    public String getShareableUrl() {
        return this.shareableUrl;
    }

    public void setShareableUrl(String shareableUrl) {
        this.shareableUrl = shareableUrl;
    }

    public IdentityVerificationCreateResponse template(IdentityVerificationTemplateReference template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationTemplateReference getTemplate() {
        return this.template;
    }

    public void setTemplate(IdentityVerificationTemplateReference template) {
        this.template = template;
    }

    public IdentityVerificationCreateResponse user(IdentityVerificationUserData user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationUserData getUser() {
        return this.user;
    }

    public void setUser(IdentityVerificationUserData user) {
        this.user = user;
    }

    public IdentityVerificationCreateResponse status(IdentityVerificationStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationStatus getStatus() {
        return this.status;
    }

    public void setStatus(IdentityVerificationStatus status) {
        this.status = status;
    }

    public IdentityVerificationCreateResponse steps(IdentityVerificationStepSummary steps) {
        this.steps = steps;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationStepSummary getSteps() {
        return this.steps;
    }

    public void setSteps(IdentityVerificationStepSummary steps) {
        this.steps = steps;
    }

    public IdentityVerificationCreateResponse documentaryVerification(DocumentaryVerification documentaryVerification) {
        this.documentaryVerification = documentaryVerification;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public DocumentaryVerification getDocumentaryVerification() {
        return this.documentaryVerification;
    }

    public void setDocumentaryVerification(DocumentaryVerification documentaryVerification) {
        this.documentaryVerification = documentaryVerification;
    }

    public IdentityVerificationCreateResponse selfieCheck(SelfieCheck selfieCheck) {
        this.selfieCheck = selfieCheck;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public SelfieCheck getSelfieCheck() {
        return this.selfieCheck;
    }

    public void setSelfieCheck(SelfieCheck selfieCheck) {
        this.selfieCheck = selfieCheck;
    }

    public IdentityVerificationCreateResponse kycCheck(KYCCheckDetails kycCheck) {
        this.kycCheck = kycCheck;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public KYCCheckDetails getKycCheck() {
        return this.kycCheck;
    }

    public void setKycCheck(KYCCheckDetails kycCheck) {
        this.kycCheck = kycCheck;
    }

    public IdentityVerificationCreateResponse riskCheck(RiskCheckDetails riskCheck) {
        this.riskCheck = riskCheck;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public RiskCheckDetails getRiskCheck() {
        return this.riskCheck;
    }

    public void setRiskCheck(RiskCheckDetails riskCheck) {
        this.riskCheck = riskCheck;
    }

    public IdentityVerificationCreateResponse watchlistScreeningId(String watchlistScreeningId) {
        this.watchlistScreeningId = watchlistScreeningId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="scr_52xR9LKo77r1Np", required=true, value="ID of the associated screening.")
    public String getWatchlistScreeningId() {
        return this.watchlistScreeningId;
    }

    public void setWatchlistScreeningId(String watchlistScreeningId) {
        this.watchlistScreeningId = watchlistScreeningId;
    }

    public IdentityVerificationCreateResponse redactedAt(OffsetDateTime redactedAt) {
        this.redactedAt = redactedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-07-24T03:26:02Z", required=true, value="An ISO8601 formatted timestamp.")
    public OffsetDateTime getRedactedAt() {
        return this.redactedAt;
    }

    public void setRedactedAt(OffsetDateTime redactedAt) {
        this.redactedAt = redactedAt;
    }

    public IdentityVerificationCreateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationCreateResponse identityVerificationCreateResponse = (IdentityVerificationCreateResponse)o;
        return Objects.equals(this.id, identityVerificationCreateResponse.id) && Objects.equals(this.clientUserId, identityVerificationCreateResponse.clientUserId) && Objects.equals(this.createdAt, identityVerificationCreateResponse.createdAt) && Objects.equals(this.completedAt, identityVerificationCreateResponse.completedAt) && Objects.equals(this.previousAttemptId, identityVerificationCreateResponse.previousAttemptId) && Objects.equals(this.shareableUrl, identityVerificationCreateResponse.shareableUrl) && Objects.equals(this.template, identityVerificationCreateResponse.template) && Objects.equals(this.user, identityVerificationCreateResponse.user) && Objects.equals((Object)this.status, (Object)identityVerificationCreateResponse.status) && Objects.equals(this.steps, identityVerificationCreateResponse.steps) && Objects.equals(this.documentaryVerification, identityVerificationCreateResponse.documentaryVerification) && Objects.equals(this.selfieCheck, identityVerificationCreateResponse.selfieCheck) && Objects.equals(this.kycCheck, identityVerificationCreateResponse.kycCheck) && Objects.equals(this.riskCheck, identityVerificationCreateResponse.riskCheck) && Objects.equals(this.watchlistScreeningId, identityVerificationCreateResponse.watchlistScreeningId) && Objects.equals(this.redactedAt, identityVerificationCreateResponse.redactedAt) && Objects.equals(this.requestId, identityVerificationCreateResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.clientUserId, this.createdAt, this.completedAt, this.previousAttemptId, this.shareableUrl, this.template, this.user, this.status, this.steps, this.documentaryVerification, this.selfieCheck, this.kycCheck, this.riskCheck, this.watchlistScreeningId, this.redactedAt, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationCreateResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    completedAt: ").append(this.toIndentedString(this.completedAt)).append("\n");
        sb.append("    previousAttemptId: ").append(this.toIndentedString(this.previousAttemptId)).append("\n");
        sb.append("    shareableUrl: ").append(this.toIndentedString(this.shareableUrl)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    documentaryVerification: ").append(this.toIndentedString(this.documentaryVerification)).append("\n");
        sb.append("    selfieCheck: ").append(this.toIndentedString(this.selfieCheck)).append("\n");
        sb.append("    kycCheck: ").append(this.toIndentedString(this.kycCheck)).append("\n");
        sb.append("    riskCheck: ").append(this.toIndentedString(this.riskCheck)).append("\n");
        sb.append("    watchlistScreeningId: ").append(this.toIndentedString(this.watchlistScreeningId)).append("\n");
        sb.append("    redactedAt: ").append(this.toIndentedString(this.redactedAt)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

