/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The address extracted from the document. The address must at least contain the following fields to be a valid address: `street`, `city`, `country`. If any are missing or unable to be extracted, the address will be null.  `region`, and `postal_code` may be null based on the addressing system. For example:  Addresses from the United Kingdom will not include a region  Addresses from Hong Kong will not include postal code  Note: Optical Character Recognition (OCR) technology may sometimes extract incorrect data from a document.")
public class IdentityVerificationDocumentAddressResponse {
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private String street;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;

    public IdentityVerificationDocumentAddressResponse street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(example="123 Main St. Unit 42", required=true, value="The full street address extracted from the document.")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public IdentityVerificationDocumentAddressResponse city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(example="Pawnee", required=true, value="City extracted from the document.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public IdentityVerificationDocumentAddressResponse region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IN", required=true, value="An ISO 3166-2 subdivision code extracted from the document. Related terms would be \"state\", \"province\", \"prefecture\", \"zone\", \"subdivision\", etc.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public IdentityVerificationDocumentAddressResponse postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="46001", required=true, value="The postal code extracted from the document. Between 2 and 10 alphanumeric characters. For US-based addresses this must be 5 numeric digits.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public IdentityVerificationDocumentAddressResponse country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(example="US", required=true, value="Valid, capitalized, two-letter ISO code representing the country extracted from the document. Must be in ISO 3166-1 alpha-2 form.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationDocumentAddressResponse identityVerificationDocumentAddressResponse = (IdentityVerificationDocumentAddressResponse)o;
        return Objects.equals(this.street, identityVerificationDocumentAddressResponse.street) && Objects.equals(this.city, identityVerificationDocumentAddressResponse.city) && Objects.equals(this.region, identityVerificationDocumentAddressResponse.region) && Objects.equals(this.postalCode, identityVerificationDocumentAddressResponse.postalCode) && Objects.equals(this.country, identityVerificationDocumentAddressResponse.country);
    }

    public int hashCode() {
        return Objects.hash(this.street, this.city, this.region, this.postalCode, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationDocumentAddressResponse {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

