/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for fetching an Identity Verification")
public class IdentityVerificationGetRequest {
    public static final String SERIALIZED_NAME_IDENTITY_VERIFICATION_ID = "identity_verification_id";
    @SerializedName(value="identity_verification_id")
    private String identityVerificationId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;

    public IdentityVerificationGetRequest identityVerificationId(String identityVerificationId) {
        this.identityVerificationId = identityVerificationId;
        return this;
    }

    @ApiModelProperty(example="idv_52xR9LKo77r1Np", required=true, value="ID of the associated Identity Verification attempt.")
    public String getIdentityVerificationId() {
        return this.identityVerificationId;
    }

    public void setIdentityVerificationId(String identityVerificationId) {
        this.identityVerificationId = identityVerificationId;
    }

    public IdentityVerificationGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public IdentityVerificationGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationGetRequest identityVerificationGetRequest = (IdentityVerificationGetRequest)o;
        return Objects.equals(this.identityVerificationId, identityVerificationGetRequest.identityVerificationId) && Objects.equals(this.secret, identityVerificationGetRequest.secret) && Objects.equals(this.clientId, identityVerificationGetRequest.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.identityVerificationId, this.secret, this.clientId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationGetRequest {\n");
        sb.append("    identityVerificationId: ").append(this.toIndentedString(this.identityVerificationId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

