/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityVerification;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Paginated list of Plaid sessions.")
public class IdentityVerificationListResponse {
    public static final String SERIALIZED_NAME_IDENTITY_VERIFICATIONS = "identity_verifications";
    @SerializedName(value="identity_verifications")
    private List<IdentityVerification> identityVerifications = new ArrayList<IdentityVerification>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public IdentityVerificationListResponse identityVerifications(List<IdentityVerification> identityVerifications) {
        this.identityVerifications = identityVerifications;
        return this;
    }

    public IdentityVerificationListResponse addIdentityVerificationsItem(IdentityVerification identityVerificationsItem) {
        this.identityVerifications.add(identityVerificationsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of Plaid sessions")
    public List<IdentityVerification> getIdentityVerifications() {
        return this.identityVerifications;
    }

    public void setIdentityVerifications(List<IdentityVerification> identityVerifications) {
        this.identityVerifications = identityVerifications;
    }

    public IdentityVerificationListResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJkaXJlY3Rpb24iOiJuZXh0Iiwib2Zmc2V0IjoiMTU5NDM", required=true, value="An identifier that determines which page of results you receive.")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public IdentityVerificationListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationListResponse identityVerificationListResponse = (IdentityVerificationListResponse)o;
        return Objects.equals(this.identityVerifications, identityVerificationListResponse.identityVerifications) && Objects.equals(this.nextCursor, identityVerificationListResponse.nextCursor) && Objects.equals(this.requestId, identityVerificationListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.identityVerifications, this.nextCursor, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationListResponse {\n");
        sb.append("    identityVerifications: ").append(this.toIndentedString(this.identityVerifications)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

