/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityVerificationRequestUserName;
import com.plaid.client.model.UserAddress;
import com.plaid.client.model.UserIDNumber;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="User information collected outside of Link, most likely via your own onboarding process.  Each of the following identity fields are optional:  `email_address`  `phone_number`  `date_of_birth`  `name`  `address`  `id_number`  Specifically, these fields are optional in that they can either be fully provided (satisfying every required field in their subschema) or omitted from the request entirely by not providing the key or value. Providing these fields via the API will result in Link skipping the data collection process for the associated user. All verification steps enabled in the associated Identity Verification Template will still be run. Verification steps will either be run immediately, or once the user completes the `accept_tos` step, depending on the value provided to the `gave_consent` field.")
public class IdentityVerificationRequestUser {
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private IdentityVerificationRequestUserName name;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private UserAddress address;
    public static final String SERIALIZED_NAME_ID_NUMBER = "id_number";
    @SerializedName(value="id_number")
    private UserIDNumber idNumber;

    public IdentityVerificationRequestUser emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user@example.com", value="A valid email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public IdentityVerificationRequestUser phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="+19876543212", value="A phone number in E.164 format.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public IdentityVerificationRequestUser dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public IdentityVerificationRequestUser name(IdentityVerificationRequestUserName name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IdentityVerificationRequestUserName getName() {
        return this.name;
    }

    public void setName(IdentityVerificationRequestUserName name) {
        this.name = name;
    }

    public IdentityVerificationRequestUser address(UserAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserAddress getAddress() {
        return this.address;
    }

    public void setAddress(UserAddress address) {
        this.address = address;
    }

    public IdentityVerificationRequestUser idNumber(UserIDNumber idNumber) {
        this.idNumber = idNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserIDNumber getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(UserIDNumber idNumber) {
        this.idNumber = idNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationRequestUser identityVerificationRequestUser = (IdentityVerificationRequestUser)o;
        return Objects.equals(this.emailAddress, identityVerificationRequestUser.emailAddress) && Objects.equals(this.phoneNumber, identityVerificationRequestUser.phoneNumber) && Objects.equals(this.dateOfBirth, identityVerificationRequestUser.dateOfBirth) && Objects.equals(this.name, identityVerificationRequestUser.name) && Objects.equals(this.address, identityVerificationRequestUser.address) && Objects.equals(this.idNumber, identityVerificationRequestUser.idNumber);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddress, this.phoneNumber, this.dateOfBirth, this.name, this.address, this.idNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationRequestUser {\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    idNumber: ").append(this.toIndentedString(this.idNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

