/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityVerificationRequestUser;
import com.plaid.client.model.IdentityVerificationRetryRequestStepsObject;
import com.plaid.client.model.Strategy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for retrying an identity verification attempt")
public class IdentityVerificationRetryRequest {
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_TEMPLATE_ID = "template_id";
    @SerializedName(value="template_id")
    private String templateId;
    public static final String SERIALIZED_NAME_STRATEGY = "strategy";
    @SerializedName(value="strategy")
    private Strategy strategy;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private IdentityVerificationRequestUser user;
    public static final String SERIALIZED_NAME_STEPS = "steps";
    @SerializedName(value="steps")
    private IdentityVerificationRetryRequestStepsObject steps;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;

    public IdentityVerificationRetryRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @ApiModelProperty(example="your-db-id-3b24110", required=true, value="A unique ID that identifies the end user in your system. This ID can also be used to associate user-specific data from other Plaid products. Financial Account Matching requires this field and the `/link/token/create` `client_user_id` to be consistent. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public IdentityVerificationRetryRequest templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @ApiModelProperty(example="idvtmp_4FrXJvfQU3zGUR", required=true, value="ID of the associated Identity Verification template.")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public IdentityVerificationRetryRequest strategy(Strategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public IdentityVerificationRetryRequest user(IdentityVerificationRequestUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IdentityVerificationRequestUser getUser() {
        return this.user;
    }

    public void setUser(IdentityVerificationRequestUser user) {
        this.user = user;
    }

    public IdentityVerificationRetryRequest steps(IdentityVerificationRetryRequestStepsObject steps) {
        this.steps = steps;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IdentityVerificationRetryRequestStepsObject getSteps() {
        return this.steps;
    }

    public void setSteps(IdentityVerificationRetryRequestStepsObject steps) {
        this.steps = steps;
    }

    public IdentityVerificationRetryRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public IdentityVerificationRetryRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationRetryRequest identityVerificationRetryRequest = (IdentityVerificationRetryRequest)o;
        return Objects.equals(this.clientUserId, identityVerificationRetryRequest.clientUserId) && Objects.equals(this.templateId, identityVerificationRetryRequest.templateId) && Objects.equals((Object)this.strategy, (Object)identityVerificationRetryRequest.strategy) && Objects.equals(this.user, identityVerificationRetryRequest.user) && Objects.equals(this.steps, identityVerificationRetryRequest.steps) && Objects.equals(this.clientId, identityVerificationRetryRequest.clientId) && Objects.equals(this.secret, identityVerificationRetryRequest.secret);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientUserId, this.templateId, this.strategy, this.user, this.steps, this.clientId, this.secret});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationRetryRequest {\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    strategy: ").append(this.toIndentedString((Object)this.strategy)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

