/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when the status of an identity verification has been updated, which can be triggered via the dashboard or the API.")
public class IdentityVerificationStatusUpdatedWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_IDENTITY_VERIFICATION_ID = "identity_verification_id";
    @SerializedName(value="identity_verification_id")
    private String identityVerificationId;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public IdentityVerificationStatusUpdatedWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`IDENTITY_VERIFICATION`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public IdentityVerificationStatusUpdatedWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`STATUS_UPDATED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public IdentityVerificationStatusUpdatedWebhook identityVerificationId(String identityVerificationId) {
        this.identityVerificationId = identityVerificationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the associated Identity Verification attempt.")
    public String getIdentityVerificationId() {
        return this.identityVerificationId;
    }

    public void setIdentityVerificationId(String identityVerificationId) {
        this.identityVerificationId = identityVerificationId;
    }

    public IdentityVerificationStatusUpdatedWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationStatusUpdatedWebhook identityVerificationStatusUpdatedWebhook = (IdentityVerificationStatusUpdatedWebhook)o;
        return Objects.equals(this.webhookType, identityVerificationStatusUpdatedWebhook.webhookType) && Objects.equals(this.webhookCode, identityVerificationStatusUpdatedWebhook.webhookCode) && Objects.equals(this.identityVerificationId, identityVerificationStatusUpdatedWebhook.identityVerificationId) && Objects.equals((Object)this.environment, (Object)identityVerificationStatusUpdatedWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.identityVerificationId, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationStatusUpdatedWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    identityVerificationId: ").append(this.toIndentedString(this.identityVerificationId)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

