/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityVerificationStepStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Each step will be one of the following values:   `active` - This step is the user's current step. They are either in the process of completing this step, or they recently closed their Identity Verification attempt while in the middle of this step. Only one step will be marked as `active` at any given point.  `success` - The Identity Verification attempt has completed this step.  `failed` - The user failed this step. This can either call the user to fail the session as a whole, or cause them to fallback to another step depending on how the Identity Verification template is configured. A failed step does not imply a failed session.  `waiting_for_prerequisite` - The user needs to complete another step first, before they progress to this step. This step may never run, depending on if the user fails an earlier step or if the step is only run as a fallback.  `not_applicable` - This step will not be run for this session.  `skipped` - The retry instructions that created this Identity Verification attempt specified that this step should be skipped.  `expired` - This step had not yet been completed when the Identity Verification attempt as a whole expired.  `canceled` - The Identity Verification attempt was canceled before the user completed this step.  `pending_review` - The Identity Verification attempt template was configured to perform a screening that had one or more hits needing review.  `manually_approved` - The step was manually overridden to pass by a team member in the dashboard.  `manually_rejected` - The step was manually overridden to fail by a team member in the dashboard.")
public class IdentityVerificationStepSummary {
    public static final String SERIALIZED_NAME_ACCEPT_TOS = "accept_tos";
    @SerializedName(value="accept_tos")
    private IdentityVerificationStepStatus acceptTos;
    public static final String SERIALIZED_NAME_VERIFY_SMS = "verify_sms";
    @SerializedName(value="verify_sms")
    private IdentityVerificationStepStatus verifySms;
    public static final String SERIALIZED_NAME_KYC_CHECK = "kyc_check";
    @SerializedName(value="kyc_check")
    private IdentityVerificationStepStatus kycCheck;
    public static final String SERIALIZED_NAME_DOCUMENTARY_VERIFICATION = "documentary_verification";
    @SerializedName(value="documentary_verification")
    private IdentityVerificationStepStatus documentaryVerification;
    public static final String SERIALIZED_NAME_SELFIE_CHECK = "selfie_check";
    @SerializedName(value="selfie_check")
    private IdentityVerificationStepStatus selfieCheck;
    public static final String SERIALIZED_NAME_WATCHLIST_SCREENING = "watchlist_screening";
    @SerializedName(value="watchlist_screening")
    private IdentityVerificationStepStatus watchlistScreening;
    public static final String SERIALIZED_NAME_RISK_CHECK = "risk_check";
    @SerializedName(value="risk_check")
    private IdentityVerificationStepStatus riskCheck;

    public IdentityVerificationStepSummary acceptTos(IdentityVerificationStepStatus acceptTos) {
        this.acceptTos = acceptTos;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationStepStatus getAcceptTos() {
        return this.acceptTos;
    }

    public void setAcceptTos(IdentityVerificationStepStatus acceptTos) {
        this.acceptTos = acceptTos;
    }

    public IdentityVerificationStepSummary verifySms(IdentityVerificationStepStatus verifySms) {
        this.verifySms = verifySms;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationStepStatus getVerifySms() {
        return this.verifySms;
    }

    public void setVerifySms(IdentityVerificationStepStatus verifySms) {
        this.verifySms = verifySms;
    }

    public IdentityVerificationStepSummary kycCheck(IdentityVerificationStepStatus kycCheck) {
        this.kycCheck = kycCheck;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationStepStatus getKycCheck() {
        return this.kycCheck;
    }

    public void setKycCheck(IdentityVerificationStepStatus kycCheck) {
        this.kycCheck = kycCheck;
    }

    public IdentityVerificationStepSummary documentaryVerification(IdentityVerificationStepStatus documentaryVerification) {
        this.documentaryVerification = documentaryVerification;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationStepStatus getDocumentaryVerification() {
        return this.documentaryVerification;
    }

    public void setDocumentaryVerification(IdentityVerificationStepStatus documentaryVerification) {
        this.documentaryVerification = documentaryVerification;
    }

    public IdentityVerificationStepSummary selfieCheck(IdentityVerificationStepStatus selfieCheck) {
        this.selfieCheck = selfieCheck;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationStepStatus getSelfieCheck() {
        return this.selfieCheck;
    }

    public void setSelfieCheck(IdentityVerificationStepStatus selfieCheck) {
        this.selfieCheck = selfieCheck;
    }

    public IdentityVerificationStepSummary watchlistScreening(IdentityVerificationStepStatus watchlistScreening) {
        this.watchlistScreening = watchlistScreening;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationStepStatus getWatchlistScreening() {
        return this.watchlistScreening;
    }

    public void setWatchlistScreening(IdentityVerificationStepStatus watchlistScreening) {
        this.watchlistScreening = watchlistScreening;
    }

    public IdentityVerificationStepSummary riskCheck(IdentityVerificationStepStatus riskCheck) {
        this.riskCheck = riskCheck;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IdentityVerificationStepStatus getRiskCheck() {
        return this.riskCheck;
    }

    public void setRiskCheck(IdentityVerificationStepStatus riskCheck) {
        this.riskCheck = riskCheck;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationStepSummary identityVerificationStepSummary = (IdentityVerificationStepSummary)o;
        return Objects.equals((Object)this.acceptTos, (Object)identityVerificationStepSummary.acceptTos) && Objects.equals((Object)this.verifySms, (Object)identityVerificationStepSummary.verifySms) && Objects.equals((Object)this.kycCheck, (Object)identityVerificationStepSummary.kycCheck) && Objects.equals((Object)this.documentaryVerification, (Object)identityVerificationStepSummary.documentaryVerification) && Objects.equals((Object)this.selfieCheck, (Object)identityVerificationStepSummary.selfieCheck) && Objects.equals((Object)this.watchlistScreening, (Object)identityVerificationStepSummary.watchlistScreening) && Objects.equals((Object)this.riskCheck, (Object)identityVerificationStepSummary.riskCheck);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptTos, this.verifySms, this.kycCheck, this.documentaryVerification, this.selfieCheck, this.watchlistScreening, this.riskCheck});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationStepSummary {\n");
        sb.append("    acceptTos: ").append(this.toIndentedString((Object)this.acceptTos)).append("\n");
        sb.append("    verifySms: ").append(this.toIndentedString((Object)this.verifySms)).append("\n");
        sb.append("    kycCheck: ").append(this.toIndentedString((Object)this.kycCheck)).append("\n");
        sb.append("    documentaryVerification: ").append(this.toIndentedString((Object)this.documentaryVerification)).append("\n");
        sb.append("    selfieCheck: ").append(this.toIndentedString((Object)this.selfieCheck)).append("\n");
        sb.append("    watchlistScreening: ").append(this.toIndentedString((Object)this.watchlistScreening)).append("\n");
        sb.append("    riskCheck: ").append(this.toIndentedString((Object)this.riskCheck)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

