/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IncomeBreakdownType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing a breakdown of the different income types on the paystub.")
public class IncomeBreakdown {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private IncomeBreakdownType type;
    public static final String SERIALIZED_NAME_RATE = "rate";
    @SerializedName(value="rate")
    private Double rate;
    public static final String SERIALIZED_NAME_HOURS = "hours";
    @SerializedName(value="hours")
    private Double hours;
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(value="total")
    private Double total;

    public IncomeBreakdown type(IncomeBreakdownType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public IncomeBreakdownType getType() {
        return this.type;
    }

    public void setType(IncomeBreakdownType type) {
        this.type = type;
    }

    public IncomeBreakdown rate(Double rate) {
        this.rate = rate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The hourly rate at which the income is paid.")
    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public IncomeBreakdown hours(Double hours) {
        this.hours = hours;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The number of hours logged for this income for this pay period.")
    public Double getHours() {
        return this.hours;
    }

    public void setHours(Double hours) {
        this.hours = hours;
    }

    public IncomeBreakdown total(Double total) {
        this.total = total;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The total pay for this pay period.")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomeBreakdown incomeBreakdown = (IncomeBreakdown)o;
        return Objects.equals((Object)this.type, (Object)incomeBreakdown.type) && Objects.equals(this.rate, incomeBreakdown.rate) && Objects.equals(this.hours, incomeBreakdown.hours) && Objects.equals(this.total, incomeBreakdown.total);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.rate, this.hours, this.total});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncomeBreakdown {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    hours: ").append(this.toIndentedString(this.hours)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

