/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaystubOverride;
import com.plaid.client.model.W2Override;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specify payroll data on the account.")
public class IncomeOverride {
    public static final String SERIALIZED_NAME_PAYSTUBS = "paystubs";
    @SerializedName(value="paystubs")
    private List<PaystubOverride> paystubs = null;
    public static final String SERIALIZED_NAME_W2S = "w2s";
    @SerializedName(value="w2s")
    private List<W2Override> w2s = null;

    public IncomeOverride paystubs(List<PaystubOverride> paystubs) {
        this.paystubs = paystubs;
        return this;
    }

    public IncomeOverride addPaystubsItem(PaystubOverride paystubsItem) {
        if (this.paystubs == null) {
            this.paystubs = new ArrayList<PaystubOverride>();
        }
        this.paystubs.add(paystubsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of paystubs associated with the account.")
    public List<PaystubOverride> getPaystubs() {
        return this.paystubs;
    }

    public void setPaystubs(List<PaystubOverride> paystubs) {
        this.paystubs = paystubs;
    }

    public IncomeOverride w2s(List<W2Override> w2s) {
        this.w2s = w2s;
        return this;
    }

    public IncomeOverride addW2sItem(W2Override w2sItem) {
        if (this.w2s == null) {
            this.w2s = new ArrayList<W2Override>();
        }
        this.w2s.add(w2sItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of w2s associated with the account.")
    public List<W2Override> getW2s() {
        return this.w2s;
    }

    public void setW2s(List<W2Override> w2s) {
        this.w2s = w2s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomeOverride incomeOverride = (IncomeOverride)o;
        return Objects.equals(this.paystubs, incomeOverride.paystubs) && Objects.equals(this.w2s, incomeOverride.w2s);
    }

    public int hashCode() {
        return Objects.hash(this.paystubs, this.w2s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncomeOverride {\n");
        sb.append("    paystubs: ").append(this.toIndentedString(this.paystubs)).append("\n");
        sb.append("    w2s: ").append(this.toIndentedString(this.w2s)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

