/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IncomeVerificationCreateRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IncomeVerificationCreateRequest defines the request schema for `/income/verification/create`")
public class IncomeVerificationCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;
    public static final String SERIALIZED_NAME_PRECHECK_ID = "precheck_id";
    @SerializedName(value="precheck_id")
    private String precheckId;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private IncomeVerificationCreateRequestOptions options;

    public IncomeVerificationCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public IncomeVerificationCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public IncomeVerificationCreateRequest webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL endpoint to which Plaid should send webhooks related to the progress of the income verification process.")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public IncomeVerificationCreateRequest precheckId(String precheckId) {
        this.precheckId = precheckId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of a precheck created with `/income/verification/precheck`. Will be used to improve conversion of the income verification flow.")
    public String getPrecheckId() {
        return this.precheckId;
    }

    public void setPrecheckId(String precheckId) {
        this.precheckId = precheckId;
    }

    public IncomeVerificationCreateRequest options(IncomeVerificationCreateRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IncomeVerificationCreateRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(IncomeVerificationCreateRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomeVerificationCreateRequest incomeVerificationCreateRequest = (IncomeVerificationCreateRequest)o;
        return Objects.equals(this.clientId, incomeVerificationCreateRequest.clientId) && Objects.equals(this.secret, incomeVerificationCreateRequest.secret) && Objects.equals(this.webhook, incomeVerificationCreateRequest.webhook) && Objects.equals(this.precheckId, incomeVerificationCreateRequest.precheckId) && Objects.equals(this.options, incomeVerificationCreateRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.webhook, this.precheckId, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncomeVerificationCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("    precheckId: ").append(this.toIndentedString(this.precheckId)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

