/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when risk signals have been processed for documents uploaded via Document Income. It will typically take a minute or two for this webhook to fire after the end user has uploaded their documents in the Document Income flow. Once this webhook has fired, `/credit/payroll_income/risk_signals/get` may then be called to determine whether the documents were successfully processed and to retrieve risk data.")
public class IncomeVerificationRiskSignalsStatusWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_RISK_SIGNALS_STATUS = "risk_signals_status";
    @SerializedName(value="risk_signals_status")
    private String riskSignalsStatus;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public IncomeVerificationRiskSignalsStatusWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`\"INCOME\"`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public IncomeVerificationRiskSignalsStatusWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`INCOME_VERIFICATION_RISK_SIGNALS`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public IncomeVerificationRiskSignalsStatusWebhook itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Item ID associated with the verification.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public IncomeVerificationRiskSignalsStatusWebhook userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid `user_id` of the User associated with this webhook, warning, or error.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public IncomeVerificationRiskSignalsStatusWebhook riskSignalsStatus(String riskSignalsStatus) {
        this.riskSignalsStatus = riskSignalsStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`RISK_SIGNALS_PROCESSING_COMPLETE`: The income verification fraud detection processing has completed. If the user uploaded multiple documents, this webhook will fire when all documents have finished processing. Call the `/credit/payroll_income/risk_signals/get` endpoint to get all risk signal data.")
    public String getRiskSignalsStatus() {
        return this.riskSignalsStatus;
    }

    public void setRiskSignalsStatus(String riskSignalsStatus) {
        this.riskSignalsStatus = riskSignalsStatus;
    }

    public IncomeVerificationRiskSignalsStatusWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomeVerificationRiskSignalsStatusWebhook incomeVerificationRiskSignalsStatusWebhook = (IncomeVerificationRiskSignalsStatusWebhook)o;
        return Objects.equals(this.webhookType, incomeVerificationRiskSignalsStatusWebhook.webhookType) && Objects.equals(this.webhookCode, incomeVerificationRiskSignalsStatusWebhook.webhookCode) && Objects.equals(this.itemId, incomeVerificationRiskSignalsStatusWebhook.itemId) && Objects.equals(this.userId, incomeVerificationRiskSignalsStatusWebhook.userId) && Objects.equals(this.riskSignalsStatus, incomeVerificationRiskSignalsStatusWebhook.riskSignalsStatus) && Objects.equals((Object)this.environment, (Object)incomeVerificationRiskSignalsStatusWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.itemId, this.userId, this.riskSignalsStatus, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncomeVerificationRiskSignalsStatusWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    riskSignalsStatus: ").append(this.toIndentedString(this.riskSignalsStatus)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

