/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WeakAliasDetermination;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Name information for the associated individual watchlist hit")
public class IndividualScreeningHitNames {
    public static final String SERIALIZED_NAME_FULL = "full";
    @SerializedName(value="full")
    private String full;
    public static final String SERIALIZED_NAME_IS_PRIMARY = "is_primary";
    @SerializedName(value="is_primary")
    private Boolean isPrimary;
    public static final String SERIALIZED_NAME_WEAK_ALIAS_DETERMINATION = "weak_alias_determination";
    @SerializedName(value="weak_alias_determination")
    private WeakAliasDetermination weakAliasDetermination;

    public IndividualScreeningHitNames full(String full) {
        this.full = full;
        return this;
    }

    @ApiModelProperty(example="Aleksey Potemkin", required=true, value="The full name of the individual, including all parts.")
    public String getFull() {
        return this.full;
    }

    public void setFull(String full) {
        this.full = full;
    }

    public IndividualScreeningHitNames isPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Primary names are those most commonly used to refer to this person. Only one name will ever be marked as primary.")
    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public IndividualScreeningHitNames weakAliasDetermination(WeakAliasDetermination weakAliasDetermination) {
        this.weakAliasDetermination = weakAliasDetermination;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WeakAliasDetermination getWeakAliasDetermination() {
        return this.weakAliasDetermination;
    }

    public void setWeakAliasDetermination(WeakAliasDetermination weakAliasDetermination) {
        this.weakAliasDetermination = weakAliasDetermination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndividualScreeningHitNames individualScreeningHitNames = (IndividualScreeningHitNames)o;
        return Objects.equals(this.full, individualScreeningHitNames.full) && Objects.equals(this.isPrimary, individualScreeningHitNames.isPrimary) && Objects.equals((Object)this.weakAliasDetermination, (Object)individualScreeningHitNames.weakAliasDetermination);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.full, this.isPrimary, this.weakAliasDetermination});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IndividualScreeningHitNames {\n");
        sb.append("    full: ").append(this.toIndentedString(this.full)).append("\n");
        sb.append("    isPrimary: ").append(this.toIndentedString(this.isPrimary)).append("\n");
        sb.append("    weakAliasDetermination: ").append(this.toIndentedString((Object)this.weakAliasDetermination)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

