/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The `inflow_model` allows you to model a test account that receives regular income or make regular payments on a loan. Any transactions generated by the `inflow_model` will appear in addition to randomly generated test data or transactions specified by `override_accounts`.")
public class InflowModel {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_INCOME_AMOUNT = "income_amount";
    @SerializedName(value="income_amount")
    private Double incomeAmount;
    public static final String SERIALIZED_NAME_PAYMENT_DAY_OF_MONTH = "payment_day_of_month";
    @SerializedName(value="payment_day_of_month")
    private Double paymentDayOfMonth;
    public static final String SERIALIZED_NAME_TRANSACTION_NAME = "transaction_name";
    @SerializedName(value="transaction_name")
    private String transactionName;
    public static final String SERIALIZED_NAME_STATEMENT_DAY_OF_MONTH = "statement_day_of_month";
    @SerializedName(value="statement_day_of_month")
    private String statementDayOfMonth;

    public InflowModel type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Inflow model. One of the following:  `none`: No income  `monthly-income`: Income occurs once per month `monthly-balance-payment`: Pays off the balance on a liability account at the given statement day of month.  `monthly-interest-only-payment`: Makes an interest-only payment on a liability account at the given statement day of month.  Note that account types supported by Liabilities will accrue interest in the Sandbox. The types impacted are account type `credit` with subtype `credit` or `paypal`, and account type `loan` with subtype `student` or `mortgage`.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public InflowModel incomeAmount(Double incomeAmount) {
        this.incomeAmount = incomeAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount of income per month. This value is required if `type` is `monthly-income`.")
    public Double getIncomeAmount() {
        return this.incomeAmount;
    }

    public void setIncomeAmount(Double incomeAmount) {
        this.incomeAmount = incomeAmount;
    }

    public InflowModel paymentDayOfMonth(Double paymentDayOfMonth) {
        this.paymentDayOfMonth = paymentDayOfMonth;
        return this;
    }

    @ApiModelProperty(required=true, value="Number between 1 and 28, or `last` meaning the last day of the month. The day of the month on which the income transaction will appear. The name of the income transaction. This field is required if `type` is `monthly-income`, `monthly-balance-payment` or `monthly-interest-only-payment`.")
    public Double getPaymentDayOfMonth() {
        return this.paymentDayOfMonth;
    }

    public void setPaymentDayOfMonth(Double paymentDayOfMonth) {
        this.paymentDayOfMonth = paymentDayOfMonth;
    }

    public InflowModel transactionName(String transactionName) {
        this.transactionName = transactionName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the income transaction. This field is required if `type` is `monthly-income`, `monthly-balance-payment` or `monthly-interest-only-payment`.")
    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public InflowModel statementDayOfMonth(String statementDayOfMonth) {
        this.statementDayOfMonth = statementDayOfMonth;
        return this;
    }

    @ApiModelProperty(required=true, value="Number between 1 and 28, or `last` meaning the last day of the month. The day of the month on which the balance is calculated for the next payment. The name of the income transaction. This field is required if `type` is `monthly-balance-payment` or `monthly-interest-only-payment`.")
    public String getStatementDayOfMonth() {
        return this.statementDayOfMonth;
    }

    public void setStatementDayOfMonth(String statementDayOfMonth) {
        this.statementDayOfMonth = statementDayOfMonth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InflowModel inflowModel = (InflowModel)o;
        return Objects.equals(this.type, inflowModel.type) && Objects.equals(this.incomeAmount, inflowModel.incomeAmount) && Objects.equals(this.paymentDayOfMonth, inflowModel.paymentDayOfMonth) && Objects.equals(this.transactionName, inflowModel.transactionName) && Objects.equals(this.statementDayOfMonth, inflowModel.statementDayOfMonth);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.incomeAmount, this.paymentDayOfMonth, this.transactionName, this.statementDayOfMonth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InflowModel {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    incomeAmount: ").append(this.toIndentedString(this.incomeAmount)).append("\n");
        sb.append("    paymentDayOfMonth: ").append(this.toIndentedString(this.paymentDayOfMonth)).append("\n");
        sb.append("    transactionName: ").append(this.toIndentedString(this.transactionName)).append("\n");
        sb.append("    statementDayOfMonth: ").append(this.toIndentedString(this.statementDayOfMonth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

