/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AuthMetadata;
import com.plaid.client.model.CountryCode;
import com.plaid.client.model.InstitutionStatus;
import com.plaid.client.model.PaymentInitiationMetadata;
import com.plaid.client.model.Products;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details relating to a specific financial institution")
public class Institution {
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<Products> products = new ArrayList<Products>();
    public static final String SERIALIZED_NAME_COUNTRY_CODES = "country_codes";
    @SerializedName(value="country_codes")
    private List<CountryCode> countryCodes = new ArrayList<CountryCode>();
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_PRIMARY_COLOR = "primary_color";
    @SerializedName(value="primary_color")
    private String primaryColor;
    public static final String SERIALIZED_NAME_LOGO = "logo";
    @SerializedName(value="logo")
    private String logo;
    public static final String SERIALIZED_NAME_ROUTING_NUMBERS = "routing_numbers";
    @SerializedName(value="routing_numbers")
    private List<String> routingNumbers = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DTC_NUMBERS = "dtc_numbers";
    @SerializedName(value="dtc_numbers")
    private List<String> dtcNumbers = null;
    public static final String SERIALIZED_NAME_OAUTH = "oauth";
    @SerializedName(value="oauth")
    private Boolean oauth;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private InstitutionStatus status;
    public static final String SERIALIZED_NAME_PAYMENT_INITIATION_METADATA = "payment_initiation_metadata";
    @SerializedName(value="payment_initiation_metadata")
    private PaymentInitiationMetadata paymentInitiationMetadata;
    public static final String SERIALIZED_NAME_AUTH_METADATA = "auth_metadata";
    @SerializedName(value="auth_metadata")
    private AuthMetadata authMetadata;

    public Institution institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the institution. Note that the same institution may have multiple records, each with different institution IDs; for example, if the institution has migrated to OAuth, there may be separate `institution_id`s for the OAuth and non-OAuth versions of the institution. Institutions that operate in different countries or with multiple login portals may also have separate `institution_id`s for each country or portal.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public Institution name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The official name of the institution.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Institution products(List<Products> products) {
        this.products = products;
        return this;
    }

    public Institution addProductsItem(Products productsItem) {
        this.products.add(productsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of the Plaid products supported by the institution. Note that only institutions that support Instant Auth will return `auth` in the product array; institutions that do not list `auth` may still support other Auth methods such as Instant Match or Automated Micro-deposit Verification. To identify institutions that support those methods, use the `auth_metadata` object. For more details, see [Full Auth coverage](https://plaid.com/docs/auth/coverage/). The `income_verification` product here indicates support for Bank Income.")
    public List<Products> getProducts() {
        return this.products;
    }

    public void setProducts(List<Products> products) {
        this.products = products;
    }

    public Institution countryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
        return this;
    }

    public Institution addCountryCodesItem(CountryCode countryCodesItem) {
        this.countryCodes.add(countryCodesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of the country codes supported by the institution.")
    public List<CountryCode> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
    }

    public Institution url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL for the institution's website")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Institution primaryColor(String primaryColor) {
        this.primaryColor = primaryColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hexadecimal representation of the primary color used by the institution")
    public String getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(String primaryColor) {
        this.primaryColor = primaryColor;
    }

    public Institution logo(String logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64 encoded representation of the institution's logo, returned as a base64 encoded 152x152 PNG. Not all institutions' logos are available.")
    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Institution routingNumbers(List<String> routingNumbers) {
        this.routingNumbers = routingNumbers;
        return this;
    }

    public Institution addRoutingNumbersItem(String routingNumbersItem) {
        this.routingNumbers.add(routingNumbersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of routing numbers known to be associated with the institution. This list is provided for the purpose of looking up institutions by routing number. It is generally comprehensive but is not guaranteed to be a complete list of routing numbers for an institution.")
    public List<String> getRoutingNumbers() {
        return this.routingNumbers;
    }

    public void setRoutingNumbers(List<String> routingNumbers) {
        this.routingNumbers = routingNumbers;
    }

    public Institution dtcNumbers(List<String> dtcNumbers) {
        this.dtcNumbers = dtcNumbers;
        return this;
    }

    public Institution addDtcNumbersItem(String dtcNumbersItem) {
        if (this.dtcNumbers == null) {
            this.dtcNumbers = new ArrayList<String>();
        }
        this.dtcNumbers.add(dtcNumbersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A partial list of DTC numbers associated with the institution.")
    public List<String> getDtcNumbers() {
        return this.dtcNumbers;
    }

    public void setDtcNumbers(List<String> dtcNumbers) {
        this.dtcNumbers = dtcNumbers;
    }

    public Institution oauth(Boolean oauth) {
        this.oauth = oauth;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates that the institution has an OAuth login flow. This will be `true` if OAuth is supported for any Items associated with the institution, even if the institution also supports non-OAuth connections.")
    public Boolean getOauth() {
        return this.oauth;
    }

    public void setOauth(Boolean oauth) {
        this.oauth = oauth;
    }

    public Institution status(InstitutionStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InstitutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(InstitutionStatus status) {
        this.status = status;
    }

    public Institution paymentInitiationMetadata(PaymentInitiationMetadata paymentInitiationMetadata) {
        this.paymentInitiationMetadata = paymentInitiationMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentInitiationMetadata getPaymentInitiationMetadata() {
        return this.paymentInitiationMetadata;
    }

    public void setPaymentInitiationMetadata(PaymentInitiationMetadata paymentInitiationMetadata) {
        this.paymentInitiationMetadata = paymentInitiationMetadata;
    }

    public Institution authMetadata(AuthMetadata authMetadata) {
        this.authMetadata = authMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AuthMetadata getAuthMetadata() {
        return this.authMetadata;
    }

    public void setAuthMetadata(AuthMetadata authMetadata) {
        this.authMetadata = authMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Institution institution = (Institution)o;
        return Objects.equals(this.institutionId, institution.institutionId) && Objects.equals(this.name, institution.name) && Objects.equals(this.products, institution.products) && Objects.equals(this.countryCodes, institution.countryCodes) && Objects.equals(this.url, institution.url) && Objects.equals(this.primaryColor, institution.primaryColor) && Objects.equals(this.logo, institution.logo) && Objects.equals(this.routingNumbers, institution.routingNumbers) && Objects.equals(this.dtcNumbers, institution.dtcNumbers) && Objects.equals(this.oauth, institution.oauth) && Objects.equals(this.status, institution.status) && Objects.equals(this.paymentInitiationMetadata, institution.paymentInitiationMetadata) && Objects.equals(this.authMetadata, institution.authMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.institutionId, this.name, this.products, this.countryCodes, this.url, this.primaryColor, this.logo, this.routingNumbers, this.dtcNumbers, this.oauth, this.status, this.paymentInitiationMetadata, this.authMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Institution {\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    countryCodes: ").append(this.toIndentedString(this.countryCodes)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    primaryColor: ").append(this.toIndentedString(this.primaryColor)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    routingNumbers: ").append(this.toIndentedString(this.routingNumbers)).append("\n");
        sb.append("    dtcNumbers: ").append(this.toIndentedString(this.dtcNumbers)).append("\n");
        sb.append("    oauth: ").append(this.toIndentedString(this.oauth)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    paymentInitiationMetadata: ").append(this.toIndentedString(this.paymentInitiationMetadata)).append("\n");
        sb.append("    authMetadata: ").append(this.toIndentedString(this.authMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

