/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.HealthIncident;
import com.plaid.client.model.ProductStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The status of an institution is determined by the health of its Item logins, Transactions updates, Investments updates, Liabilities updates, Auth requests, Balance requests, Identity requests, Investments requests, and Liabilities requests. A login attempt is conducted during the initial Item add in Link. If there is not enough traffic to accurately calculate an institution's status, Plaid will return null rather than potentially inaccurate data.  Institution status is accessible in the Dashboard and via the API using the `/institutions/get_by_id` endpoint with the `include_status` option set to true. Note that institution status is not available in the Sandbox environment. ")
public class InstitutionStatus {
    public static final String SERIALIZED_NAME_ITEM_LOGINS = "item_logins";
    @SerializedName(value="item_logins")
    private ProductStatus itemLogins;
    public static final String SERIALIZED_NAME_TRANSACTIONS_UPDATES = "transactions_updates";
    @SerializedName(value="transactions_updates")
    private ProductStatus transactionsUpdates;
    public static final String SERIALIZED_NAME_AUTH = "auth";
    @SerializedName(value="auth")
    private ProductStatus auth;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private ProductStatus identity;
    public static final String SERIALIZED_NAME_INVESTMENTS_UPDATES = "investments_updates";
    @SerializedName(value="investments_updates")
    private ProductStatus investmentsUpdates;
    public static final String SERIALIZED_NAME_LIABILITIES_UPDATES = "liabilities_updates";
    @SerializedName(value="liabilities_updates")
    private ProductStatus liabilitiesUpdates;
    public static final String SERIALIZED_NAME_LIABILITIES = "liabilities";
    @SerializedName(value="liabilities")
    private ProductStatus liabilities;
    public static final String SERIALIZED_NAME_INVESTMENTS = "investments";
    @SerializedName(value="investments")
    private ProductStatus investments;
    public static final String SERIALIZED_NAME_HEALTH_INCIDENTS = "health_incidents";
    @SerializedName(value="health_incidents")
    private List<HealthIncident> healthIncidents = null;

    public InstitutionStatus itemLogins(ProductStatus itemLogins) {
        this.itemLogins = itemLogins;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProductStatus getItemLogins() {
        return this.itemLogins;
    }

    public void setItemLogins(ProductStatus itemLogins) {
        this.itemLogins = itemLogins;
    }

    public InstitutionStatus transactionsUpdates(ProductStatus transactionsUpdates) {
        this.transactionsUpdates = transactionsUpdates;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProductStatus getTransactionsUpdates() {
        return this.transactionsUpdates;
    }

    public void setTransactionsUpdates(ProductStatus transactionsUpdates) {
        this.transactionsUpdates = transactionsUpdates;
    }

    public InstitutionStatus auth(ProductStatus auth) {
        this.auth = auth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProductStatus getAuth() {
        return this.auth;
    }

    public void setAuth(ProductStatus auth) {
        this.auth = auth;
    }

    public InstitutionStatus identity(ProductStatus identity) {
        this.identity = identity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProductStatus getIdentity() {
        return this.identity;
    }

    public void setIdentity(ProductStatus identity) {
        this.identity = identity;
    }

    public InstitutionStatus investmentsUpdates(ProductStatus investmentsUpdates) {
        this.investmentsUpdates = investmentsUpdates;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProductStatus getInvestmentsUpdates() {
        return this.investmentsUpdates;
    }

    public void setInvestmentsUpdates(ProductStatus investmentsUpdates) {
        this.investmentsUpdates = investmentsUpdates;
    }

    public InstitutionStatus liabilitiesUpdates(ProductStatus liabilitiesUpdates) {
        this.liabilitiesUpdates = liabilitiesUpdates;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProductStatus getLiabilitiesUpdates() {
        return this.liabilitiesUpdates;
    }

    public void setLiabilitiesUpdates(ProductStatus liabilitiesUpdates) {
        this.liabilitiesUpdates = liabilitiesUpdates;
    }

    public InstitutionStatus liabilities(ProductStatus liabilities) {
        this.liabilities = liabilities;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProductStatus getLiabilities() {
        return this.liabilities;
    }

    public void setLiabilities(ProductStatus liabilities) {
        this.liabilities = liabilities;
    }

    public InstitutionStatus investments(ProductStatus investments) {
        this.investments = investments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProductStatus getInvestments() {
        return this.investments;
    }

    public void setInvestments(ProductStatus investments) {
        this.investments = investments;
    }

    public InstitutionStatus healthIncidents(List<HealthIncident> healthIncidents) {
        this.healthIncidents = healthIncidents;
        return this;
    }

    public InstitutionStatus addHealthIncidentsItem(HealthIncident healthIncidentsItem) {
        if (this.healthIncidents == null) {
            this.healthIncidents = new ArrayList<HealthIncident>();
        }
        this.healthIncidents.add(healthIncidentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details of recent health incidents associated with the institution.")
    public List<HealthIncident> getHealthIncidents() {
        return this.healthIncidents;
    }

    public void setHealthIncidents(List<HealthIncident> healthIncidents) {
        this.healthIncidents = healthIncidents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionStatus institutionStatus = (InstitutionStatus)o;
        return Objects.equals(this.itemLogins, institutionStatus.itemLogins) && Objects.equals(this.transactionsUpdates, institutionStatus.transactionsUpdates) && Objects.equals(this.auth, institutionStatus.auth) && Objects.equals(this.identity, institutionStatus.identity) && Objects.equals(this.investmentsUpdates, institutionStatus.investmentsUpdates) && Objects.equals(this.liabilitiesUpdates, institutionStatus.liabilitiesUpdates) && Objects.equals(this.liabilities, institutionStatus.liabilities) && Objects.equals(this.investments, institutionStatus.investments) && Objects.equals(this.healthIncidents, institutionStatus.healthIncidents);
    }

    public int hashCode() {
        return Objects.hash(this.itemLogins, this.transactionsUpdates, this.auth, this.identity, this.investmentsUpdates, this.liabilitiesUpdates, this.liabilities, this.investments, this.healthIncidents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionStatus {\n");
        sb.append("    itemLogins: ").append(this.toIndentedString(this.itemLogins)).append("\n");
        sb.append("    transactionsUpdates: ").append(this.toIndentedString(this.transactionsUpdates)).append("\n");
        sb.append("    auth: ").append(this.toIndentedString(this.auth)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    investmentsUpdates: ").append(this.toIndentedString(this.investmentsUpdates)).append("\n");
        sb.append("    liabilitiesUpdates: ").append(this.toIndentedString(this.liabilitiesUpdates)).append("\n");
        sb.append("    liabilities: ").append(this.toIndentedString(this.liabilities)).append("\n");
        sb.append("    investments: ").append(this.toIndentedString(this.investments)).append("\n");
        sb.append("    healthIncidents: ").append(this.toIndentedString(this.healthIncidents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

