/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when institution status meets the conditions configured in the developer dashboard.")
public class InstitutionStatusAlertWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_INSTITUTION_OVERALL_SUCCESS_RATE = "institution_overall_success_rate";
    @SerializedName(value="institution_overall_success_rate")
    private Double institutionOverallSuccessRate;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public InstitutionStatusAlertWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`DASHBOARD_CONFIGURED_ALERT`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public InstitutionStatusAlertWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`INSTITUTION_STATUS_ALERT_TRIGGERED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public InstitutionStatusAlertWebhook institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the associated institution.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public InstitutionStatusAlertWebhook institutionOverallSuccessRate(Double institutionOverallSuccessRate) {
        this.institutionOverallSuccessRate = institutionOverallSuccessRate;
        return this;
    }

    @ApiModelProperty(required=true, value="The global success rate of the institution, calculated based on item add health.")
    public Double getInstitutionOverallSuccessRate() {
        return this.institutionOverallSuccessRate;
    }

    public void setInstitutionOverallSuccessRate(Double institutionOverallSuccessRate) {
        this.institutionOverallSuccessRate = institutionOverallSuccessRate;
    }

    public InstitutionStatusAlertWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionStatusAlertWebhook institutionStatusAlertWebhook = (InstitutionStatusAlertWebhook)o;
        return Objects.equals(this.webhookType, institutionStatusAlertWebhook.webhookType) && Objects.equals(this.webhookCode, institutionStatusAlertWebhook.webhookCode) && Objects.equals(this.institutionId, institutionStatusAlertWebhook.institutionId) && Objects.equals(this.institutionOverallSuccessRate, institutionStatusAlertWebhook.institutionOverallSuccessRate) && Objects.equals((Object)this.environment, (Object)institutionStatusAlertWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.institutionId, this.institutionOverallSuccessRate, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionStatusAlertWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    institutionOverallSuccessRate: ").append(this.toIndentedString(this.institutionOverallSuccessRate)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

