/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CountryCode;
import com.plaid.client.model.InstitutionsGetByIdRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="InstitutionsGetByIdRequest defines the request schema for `/institutions/get_by_id`")
public class InstitutionsGetByIdRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_COUNTRY_CODES = "country_codes";
    @SerializedName(value="country_codes")
    private List<CountryCode> countryCodes = new ArrayList<CountryCode>();
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private InstitutionsGetByIdRequestOptions options;

    public InstitutionsGetByIdRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public InstitutionsGetByIdRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public InstitutionsGetByIdRequest institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the institution to get details about")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public InstitutionsGetByIdRequest countryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
        return this;
    }

    public InstitutionsGetByIdRequest addCountryCodesItem(CountryCode countryCodesItem) {
        this.countryCodes.add(countryCodesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specify which country or countries to include institutions from, using the ISO-3166-1 alpha-2 country code standard. In API versions 2019-05-29 and earlier, the `country_codes` parameter is an optional parameter within the `options` object and will default to `[US]` if it is not supplied. ")
    public List<CountryCode> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
    }

    public InstitutionsGetByIdRequest options(InstitutionsGetByIdRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InstitutionsGetByIdRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(InstitutionsGetByIdRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionsGetByIdRequest institutionsGetByIdRequest = (InstitutionsGetByIdRequest)o;
        return Objects.equals(this.clientId, institutionsGetByIdRequest.clientId) && Objects.equals(this.secret, institutionsGetByIdRequest.secret) && Objects.equals(this.institutionId, institutionsGetByIdRequest.institutionId) && Objects.equals(this.countryCodes, institutionsGetByIdRequest.countryCodes) && Objects.equals(this.options, institutionsGetByIdRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.institutionId, this.countryCodes, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionsGetByIdRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    countryCodes: ").append(this.toIndentedString(this.countryCodes)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

