/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies optional parameters for `/institutions/get_by_id`. If provided, must not be `null`.")
public class InstitutionsGetByIdRequestOptions {
    public static final String SERIALIZED_NAME_INCLUDE_OPTIONAL_METADATA = "include_optional_metadata";
    @SerializedName(value="include_optional_metadata")
    private Boolean includeOptionalMetadata = false;
    public static final String SERIALIZED_NAME_INCLUDE_STATUS = "include_status";
    @SerializedName(value="include_status")
    private Boolean includeStatus = false;
    public static final String SERIALIZED_NAME_INCLUDE_AUTH_METADATA = "include_auth_metadata";
    @SerializedName(value="include_auth_metadata")
    private Boolean includeAuthMetadata = false;
    public static final String SERIALIZED_NAME_INCLUDE_PAYMENT_INITIATION_METADATA = "include_payment_initiation_metadata";
    @SerializedName(value="include_payment_initiation_metadata")
    private Boolean includePaymentInitiationMetadata = false;

    public InstitutionsGetByIdRequestOptions includeOptionalMetadata(Boolean includeOptionalMetadata) {
        this.includeOptionalMetadata = includeOptionalMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, return an institution's logo, brand color, and URL. When available, the bank's logo is returned as a base64 encoded 152x152 PNG, the brand color is in hexadecimal format. The default value is `false`.  Note that Plaid does not own any of the logos shared by the API and that by accessing or using these logos, you agree that you are doing so at your own risk and will, if necessary, obtain all required permissions from the appropriate rights holders and adhere to any applicable usage guidelines. Plaid disclaims all express or implied warranties with respect to the logos.")
    public Boolean getIncludeOptionalMetadata() {
        return this.includeOptionalMetadata;
    }

    public void setIncludeOptionalMetadata(Boolean includeOptionalMetadata) {
        this.includeOptionalMetadata = includeOptionalMetadata;
    }

    public InstitutionsGetByIdRequestOptions includeStatus(Boolean includeStatus) {
        this.includeStatus = includeStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, the response will include status information about the institution. Default value is `false`.")
    public Boolean getIncludeStatus() {
        return this.includeStatus;
    }

    public void setIncludeStatus(Boolean includeStatus) {
        this.includeStatus = includeStatus;
    }

    public InstitutionsGetByIdRequestOptions includeAuthMetadata(Boolean includeAuthMetadata) {
        this.includeAuthMetadata = includeAuthMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, returns metadata related to the Auth product indicating which auth methods are supported.")
    public Boolean getIncludeAuthMetadata() {
        return this.includeAuthMetadata;
    }

    public void setIncludeAuthMetadata(Boolean includeAuthMetadata) {
        this.includeAuthMetadata = includeAuthMetadata;
    }

    public InstitutionsGetByIdRequestOptions includePaymentInitiationMetadata(Boolean includePaymentInitiationMetadata) {
        this.includePaymentInitiationMetadata = includePaymentInitiationMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, returns metadata related to the Payment Initiation product indicating which payment configurations are supported.")
    public Boolean getIncludePaymentInitiationMetadata() {
        return this.includePaymentInitiationMetadata;
    }

    public void setIncludePaymentInitiationMetadata(Boolean includePaymentInitiationMetadata) {
        this.includePaymentInitiationMetadata = includePaymentInitiationMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionsGetByIdRequestOptions institutionsGetByIdRequestOptions = (InstitutionsGetByIdRequestOptions)o;
        return Objects.equals(this.includeOptionalMetadata, institutionsGetByIdRequestOptions.includeOptionalMetadata) && Objects.equals(this.includeStatus, institutionsGetByIdRequestOptions.includeStatus) && Objects.equals(this.includeAuthMetadata, institutionsGetByIdRequestOptions.includeAuthMetadata) && Objects.equals(this.includePaymentInitiationMetadata, institutionsGetByIdRequestOptions.includePaymentInitiationMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.includeOptionalMetadata, this.includeStatus, this.includeAuthMetadata, this.includePaymentInitiationMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionsGetByIdRequestOptions {\n");
        sb.append("    includeOptionalMetadata: ").append(this.toIndentedString(this.includeOptionalMetadata)).append("\n");
        sb.append("    includeStatus: ").append(this.toIndentedString(this.includeStatus)).append("\n");
        sb.append("    includeAuthMetadata: ").append(this.toIndentedString(this.includeAuthMetadata)).append("\n");
        sb.append("    includePaymentInitiationMetadata: ").append(this.toIndentedString(this.includePaymentInitiationMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

