/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CountryCode;
import com.plaid.client.model.InstitutionsGetRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="InstitutionsGetRequest defines the request schema for `/institutions/get`")
public class InstitutionsGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private Integer offset;
    public static final String SERIALIZED_NAME_COUNTRY_CODES = "country_codes";
    @SerializedName(value="country_codes")
    private List<CountryCode> countryCodes = new ArrayList<CountryCode>();
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private InstitutionsGetRequestOptions options;

    public InstitutionsGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public InstitutionsGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public InstitutionsGetRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of Institutions to return.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public InstitutionsGetRequest offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of Institutions to skip.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public InstitutionsGetRequest countryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
        return this;
    }

    public InstitutionsGetRequest addCountryCodesItem(CountryCode countryCodesItem) {
        this.countryCodes.add(countryCodesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specify which country or countries to include institutions from, using the ISO-3166-1 alpha-2 country code standard.  In API versions 2019-05-29 and earlier, the `country_codes` parameter is an optional parameter within the `options` object and will default to `[US]` if it is not supplied. ")
    public List<CountryCode> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
    }

    public InstitutionsGetRequest options(InstitutionsGetRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InstitutionsGetRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(InstitutionsGetRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionsGetRequest institutionsGetRequest = (InstitutionsGetRequest)o;
        return Objects.equals(this.clientId, institutionsGetRequest.clientId) && Objects.equals(this.secret, institutionsGetRequest.secret) && Objects.equals(this.count, institutionsGetRequest.count) && Objects.equals(this.offset, institutionsGetRequest.offset) && Objects.equals(this.countryCodes, institutionsGetRequest.countryCodes) && Objects.equals(this.options, institutionsGetRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.count, this.offset, this.countryCodes, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionsGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    countryCodes: ").append(this.toIndentedString(this.countryCodes)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

