/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Products;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An optional object to filter `/institutions/get` results.")
public class InstitutionsGetRequestOptions {
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<Products> products = null;
    public static final String SERIALIZED_NAME_ROUTING_NUMBERS = "routing_numbers";
    @SerializedName(value="routing_numbers")
    private List<String> routingNumbers = null;
    public static final String SERIALIZED_NAME_OAUTH = "oauth";
    @SerializedName(value="oauth")
    private Boolean oauth;
    public static final String SERIALIZED_NAME_INCLUDE_OPTIONAL_METADATA = "include_optional_metadata";
    @SerializedName(value="include_optional_metadata")
    private Boolean includeOptionalMetadata;
    public static final String SERIALIZED_NAME_INCLUDE_AUTH_METADATA = "include_auth_metadata";
    @SerializedName(value="include_auth_metadata")
    private Boolean includeAuthMetadata = false;
    public static final String SERIALIZED_NAME_INCLUDE_PAYMENT_INITIATION_METADATA = "include_payment_initiation_metadata";
    @SerializedName(value="include_payment_initiation_metadata")
    private Boolean includePaymentInitiationMetadata = false;

    public InstitutionsGetRequestOptions products(List<Products> products) {
        this.products = products;
        return this;
    }

    public InstitutionsGetRequestOptions addProductsItem(Products productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<Products>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter the Institutions based on which products they support. Will only return institutions that support all listed products. When filtering based on `auth`, an institution must support Instant Auth to match the criterion.")
    public List<Products> getProducts() {
        return this.products;
    }

    public void setProducts(List<Products> products) {
        this.products = products;
    }

    public InstitutionsGetRequestOptions routingNumbers(List<String> routingNumbers) {
        this.routingNumbers = routingNumbers;
        return this;
    }

    public InstitutionsGetRequestOptions addRoutingNumbersItem(String routingNumbersItem) {
        if (this.routingNumbers == null) {
            this.routingNumbers = new ArrayList<String>();
        }
        this.routingNumbers.add(routingNumbersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify an array of routing numbers to filter institutions. The response will only return institutions that match all of the routing numbers in the array. Routing number records used for this matching are generally comprehensive; however, failure to match a given routing number to an institution does not necessarily mean that the institution is unsupported by Plaid.")
    public List<String> getRoutingNumbers() {
        return this.routingNumbers;
    }

    public void setRoutingNumbers(List<String> routingNumbers) {
        this.routingNumbers = routingNumbers;
    }

    public InstitutionsGetRequestOptions oauth(Boolean oauth) {
        this.oauth = oauth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Limit results to institutions with or without OAuth login flows. Note that institutions will have `oauth` set to `true` if some Items associated with that institution are required to use OAuth flows; institutions in a state of migration to OAuth will have the `oauth` attribute set to `true`.")
    public Boolean getOauth() {
        return this.oauth;
    }

    public void setOauth(Boolean oauth) {
        this.oauth = oauth;
    }

    public InstitutionsGetRequestOptions includeOptionalMetadata(Boolean includeOptionalMetadata) {
        this.includeOptionalMetadata = includeOptionalMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, return the institution's homepage URL, logo and primary brand color.  Note that Plaid does not own any of the logos shared by the API, and that by accessing or using these logos, you agree that you are doing so at your own risk and will, if necessary, obtain all required permissions from the appropriate rights holders and adhere to any applicable usage guidelines. Plaid disclaims all express or implied warranties with respect to the logos.")
    public Boolean getIncludeOptionalMetadata() {
        return this.includeOptionalMetadata;
    }

    public void setIncludeOptionalMetadata(Boolean includeOptionalMetadata) {
        this.includeOptionalMetadata = includeOptionalMetadata;
    }

    public InstitutionsGetRequestOptions includeAuthMetadata(Boolean includeAuthMetadata) {
        this.includeAuthMetadata = includeAuthMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, returns metadata related to the Auth product indicating which auth methods are supported.")
    public Boolean getIncludeAuthMetadata() {
        return this.includeAuthMetadata;
    }

    public void setIncludeAuthMetadata(Boolean includeAuthMetadata) {
        this.includeAuthMetadata = includeAuthMetadata;
    }

    public InstitutionsGetRequestOptions includePaymentInitiationMetadata(Boolean includePaymentInitiationMetadata) {
        this.includePaymentInitiationMetadata = includePaymentInitiationMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, returns metadata related to the Payment Initiation product indicating which payment configurations are supported.")
    public Boolean getIncludePaymentInitiationMetadata() {
        return this.includePaymentInitiationMetadata;
    }

    public void setIncludePaymentInitiationMetadata(Boolean includePaymentInitiationMetadata) {
        this.includePaymentInitiationMetadata = includePaymentInitiationMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionsGetRequestOptions institutionsGetRequestOptions = (InstitutionsGetRequestOptions)o;
        return Objects.equals(this.products, institutionsGetRequestOptions.products) && Objects.equals(this.routingNumbers, institutionsGetRequestOptions.routingNumbers) && Objects.equals(this.oauth, institutionsGetRequestOptions.oauth) && Objects.equals(this.includeOptionalMetadata, institutionsGetRequestOptions.includeOptionalMetadata) && Objects.equals(this.includeAuthMetadata, institutionsGetRequestOptions.includeAuthMetadata) && Objects.equals(this.includePaymentInitiationMetadata, institutionsGetRequestOptions.includePaymentInitiationMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.products, this.routingNumbers, this.oauth, this.includeOptionalMetadata, this.includeAuthMetadata, this.includePaymentInitiationMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionsGetRequestOptions {\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    routingNumbers: ").append(this.toIndentedString(this.routingNumbers)).append("\n");
        sb.append("    oauth: ").append(this.toIndentedString(this.oauth)).append("\n");
        sb.append("    includeOptionalMetadata: ").append(this.toIndentedString(this.includeOptionalMetadata)).append("\n");
        sb.append("    includeAuthMetadata: ").append(this.toIndentedString(this.includeAuthMetadata)).append("\n");
        sb.append("    includePaymentInitiationMetadata: ").append(this.toIndentedString(this.includePaymentInitiationMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

