/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountSubtype;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An account filter to apply to institutions search requests")
public class InstitutionsSearchAccountFilter {
    public static final String SERIALIZED_NAME_LOAN = "loan";
    @SerializedName(value="loan")
    private List<AccountSubtype> loan = null;
    public static final String SERIALIZED_NAME_DEPOSITORY = "depository";
    @SerializedName(value="depository")
    private List<AccountSubtype> depository = null;
    public static final String SERIALIZED_NAME_CREDIT = "credit";
    @SerializedName(value="credit")
    private List<AccountSubtype> credit = null;
    public static final String SERIALIZED_NAME_INVESTMENT = "investment";
    @SerializedName(value="investment")
    private List<AccountSubtype> investment = null;

    public InstitutionsSearchAccountFilter loan(List<AccountSubtype> loan) {
        this.loan = loan;
        return this;
    }

    public InstitutionsSearchAccountFilter addLoanItem(AccountSubtype loanItem) {
        if (this.loan == null) {
            this.loan = new ArrayList<AccountSubtype>();
        }
        this.loan.add(loanItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<AccountSubtype> getLoan() {
        return this.loan;
    }

    public void setLoan(List<AccountSubtype> loan) {
        this.loan = loan;
    }

    public InstitutionsSearchAccountFilter depository(List<AccountSubtype> depository) {
        this.depository = depository;
        return this;
    }

    public InstitutionsSearchAccountFilter addDepositoryItem(AccountSubtype depositoryItem) {
        if (this.depository == null) {
            this.depository = new ArrayList<AccountSubtype>();
        }
        this.depository.add(depositoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<AccountSubtype> getDepository() {
        return this.depository;
    }

    public void setDepository(List<AccountSubtype> depository) {
        this.depository = depository;
    }

    public InstitutionsSearchAccountFilter credit(List<AccountSubtype> credit) {
        this.credit = credit;
        return this;
    }

    public InstitutionsSearchAccountFilter addCreditItem(AccountSubtype creditItem) {
        if (this.credit == null) {
            this.credit = new ArrayList<AccountSubtype>();
        }
        this.credit.add(creditItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<AccountSubtype> getCredit() {
        return this.credit;
    }

    public void setCredit(List<AccountSubtype> credit) {
        this.credit = credit;
    }

    public InstitutionsSearchAccountFilter investment(List<AccountSubtype> investment) {
        this.investment = investment;
        return this;
    }

    public InstitutionsSearchAccountFilter addInvestmentItem(AccountSubtype investmentItem) {
        if (this.investment == null) {
            this.investment = new ArrayList<AccountSubtype>();
        }
        this.investment.add(investmentItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<AccountSubtype> getInvestment() {
        return this.investment;
    }

    public void setInvestment(List<AccountSubtype> investment) {
        this.investment = investment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionsSearchAccountFilter institutionsSearchAccountFilter = (InstitutionsSearchAccountFilter)o;
        return Objects.equals(this.loan, institutionsSearchAccountFilter.loan) && Objects.equals(this.depository, institutionsSearchAccountFilter.depository) && Objects.equals(this.credit, institutionsSearchAccountFilter.credit) && Objects.equals(this.investment, institutionsSearchAccountFilter.investment);
    }

    public int hashCode() {
        return Objects.hash(this.loan, this.depository, this.credit, this.investment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionsSearchAccountFilter {\n");
        sb.append("    loan: ").append(this.toIndentedString(this.loan)).append("\n");
        sb.append("    depository: ").append(this.toIndentedString(this.depository)).append("\n");
        sb.append("    credit: ").append(this.toIndentedString(this.credit)).append("\n");
        sb.append("    investment: ").append(this.toIndentedString(this.investment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

