/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CountryCode;
import com.plaid.client.model.InstitutionsSearchRequestOptions;
import com.plaid.client.model.Products;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="InstitutionsSearchRequest defines the request schema for `/institutions/search`")
public class InstitutionsSearchRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<Products> products = null;
    public static final String SERIALIZED_NAME_COUNTRY_CODES = "country_codes";
    @SerializedName(value="country_codes")
    private List<CountryCode> countryCodes = new ArrayList<CountryCode>();
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private InstitutionsSearchRequestOptions options;

    public InstitutionsSearchRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public InstitutionsSearchRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public InstitutionsSearchRequest query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(required=true, value="The search query. Institutions with names matching the query are returned")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public InstitutionsSearchRequest products(List<Products> products) {
        this.products = products;
        return this;
    }

    public InstitutionsSearchRequest addProductsItem(Products productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<Products>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter the Institutions based on whether they support all products listed in `products`. Provide `null` to get institutions regardless of supported products. Note that when `auth` is specified as a product, if you are enabled for Instant Match or Automated Micro-deposits, institutions that support those products will be returned even if `auth` is not present in their product array.")
    public List<Products> getProducts() {
        return this.products;
    }

    public void setProducts(List<Products> products) {
        this.products = products;
    }

    public InstitutionsSearchRequest countryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
        return this;
    }

    public InstitutionsSearchRequest addCountryCodesItem(CountryCode countryCodesItem) {
        this.countryCodes.add(countryCodesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specify which country or countries to include institutions from, using the ISO-3166-1 alpha-2 country code standard. In API versions 2019-05-29 and earlier, the `country_codes` parameter is an optional parameter within the `options` object and will default to `[US]` if it is not supplied. ")
    public List<CountryCode> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(List<CountryCode> countryCodes) {
        this.countryCodes = countryCodes;
    }

    public InstitutionsSearchRequest options(InstitutionsSearchRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InstitutionsSearchRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(InstitutionsSearchRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionsSearchRequest institutionsSearchRequest = (InstitutionsSearchRequest)o;
        return Objects.equals(this.clientId, institutionsSearchRequest.clientId) && Objects.equals(this.secret, institutionsSearchRequest.secret) && Objects.equals(this.query, institutionsSearchRequest.query) && Objects.equals(this.products, institutionsSearchRequest.products) && Objects.equals(this.countryCodes, institutionsSearchRequest.countryCodes) && Objects.equals(this.options, institutionsSearchRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.query, this.products, this.countryCodes, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionsSearchRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    countryCodes: ").append(this.toIndentedString(this.countryCodes)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

