/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.InstitutionsSearchPaymentInitiationOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An optional object to filter `/institutions/search` results.")
public class InstitutionsSearchRequestOptions {
    public static final String SERIALIZED_NAME_OAUTH = "oauth";
    @SerializedName(value="oauth")
    private Boolean oauth;
    public static final String SERIALIZED_NAME_INCLUDE_OPTIONAL_METADATA = "include_optional_metadata";
    @SerializedName(value="include_optional_metadata")
    private Boolean includeOptionalMetadata;
    public static final String SERIALIZED_NAME_INCLUDE_AUTH_METADATA = "include_auth_metadata";
    @SerializedName(value="include_auth_metadata")
    private Boolean includeAuthMetadata = false;
    public static final String SERIALIZED_NAME_INCLUDE_PAYMENT_INITIATION_METADATA = "include_payment_initiation_metadata";
    @SerializedName(value="include_payment_initiation_metadata")
    private Boolean includePaymentInitiationMetadata = false;
    public static final String SERIALIZED_NAME_PAYMENT_INITIATION = "payment_initiation";
    @SerializedName(value="payment_initiation")
    private InstitutionsSearchPaymentInitiationOptions paymentInitiation;

    public InstitutionsSearchRequestOptions oauth(Boolean oauth) {
        this.oauth = oauth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Limit results to institutions with or without OAuth login flows. Note that institutions will have `oauth` set to `true` if some Items associated with that institution are required to use OAuth flows; institutions in a state of migration to OAuth will have the `oauth` attribute set to `true`.")
    public Boolean getOauth() {
        return this.oauth;
    }

    public void setOauth(Boolean oauth) {
        this.oauth = oauth;
    }

    public InstitutionsSearchRequestOptions includeOptionalMetadata(Boolean includeOptionalMetadata) {
        this.includeOptionalMetadata = includeOptionalMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When true, return the institution's homepage URL, logo and primary brand color.")
    public Boolean getIncludeOptionalMetadata() {
        return this.includeOptionalMetadata;
    }

    public void setIncludeOptionalMetadata(Boolean includeOptionalMetadata) {
        this.includeOptionalMetadata = includeOptionalMetadata;
    }

    public InstitutionsSearchRequestOptions includeAuthMetadata(Boolean includeAuthMetadata) {
        this.includeAuthMetadata = includeAuthMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, returns metadata related to the Auth product indicating which auth methods are supported.")
    public Boolean getIncludeAuthMetadata() {
        return this.includeAuthMetadata;
    }

    public void setIncludeAuthMetadata(Boolean includeAuthMetadata) {
        this.includeAuthMetadata = includeAuthMetadata;
    }

    public InstitutionsSearchRequestOptions includePaymentInitiationMetadata(Boolean includePaymentInitiationMetadata) {
        this.includePaymentInitiationMetadata = includePaymentInitiationMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, returns metadata related to the Payment Initiation product indicating which payment configurations are supported.")
    public Boolean getIncludePaymentInitiationMetadata() {
        return this.includePaymentInitiationMetadata;
    }

    public void setIncludePaymentInitiationMetadata(Boolean includePaymentInitiationMetadata) {
        this.includePaymentInitiationMetadata = includePaymentInitiationMetadata;
    }

    public InstitutionsSearchRequestOptions paymentInitiation(InstitutionsSearchPaymentInitiationOptions paymentInitiation) {
        this.paymentInitiation = paymentInitiation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InstitutionsSearchPaymentInitiationOptions getPaymentInitiation() {
        return this.paymentInitiation;
    }

    public void setPaymentInitiation(InstitutionsSearchPaymentInitiationOptions paymentInitiation) {
        this.paymentInitiation = paymentInitiation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionsSearchRequestOptions institutionsSearchRequestOptions = (InstitutionsSearchRequestOptions)o;
        return Objects.equals(this.oauth, institutionsSearchRequestOptions.oauth) && Objects.equals(this.includeOptionalMetadata, institutionsSearchRequestOptions.includeOptionalMetadata) && Objects.equals(this.includeAuthMetadata, institutionsSearchRequestOptions.includeAuthMetadata) && Objects.equals(this.includePaymentInitiationMetadata, institutionsSearchRequestOptions.includePaymentInitiationMetadata) && Objects.equals(this.paymentInitiation, institutionsSearchRequestOptions.paymentInitiation);
    }

    public int hashCode() {
        return Objects.hash(this.oauth, this.includeOptionalMetadata, this.includeAuthMetadata, this.includePaymentInitiationMetadata, this.paymentInitiation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionsSearchRequestOptions {\n");
        sb.append("    oauth: ").append(this.toIndentedString(this.oauth)).append("\n");
        sb.append("    includeOptionalMetadata: ").append(this.toIndentedString(this.includeOptionalMetadata)).append("\n");
        sb.append("    includeAuthMetadata: ").append(this.toIndentedString(this.includeAuthMetadata)).append("\n");
        sb.append("    includePaymentInitiationMetadata: ").append(this.toIndentedString(this.includePaymentInitiationMetadata)).append("\n");
        sb.append("    paymentInitiation: ").append(this.toIndentedString(this.paymentInitiation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

