/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Institution;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="InstitutionsSearchResponse defines the response schema for `/institutions/search`")
public class InstitutionsSearchResponse {
    public static final String SERIALIZED_NAME_INSTITUTIONS = "institutions";
    @SerializedName(value="institutions")
    private List<Institution> institutions = new ArrayList<Institution>();
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public InstitutionsSearchResponse institutions(List<Institution> institutions) {
        this.institutions = institutions;
        return this;
    }

    public InstitutionsSearchResponse addInstitutionsItem(Institution institutionsItem) {
        this.institutions.add(institutionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of institutions matching the search criteria")
    public List<Institution> getInstitutions() {
        return this.institutions;
    }

    public void setInstitutions(List<Institution> institutions) {
        this.institutions = institutions;
    }

    public InstitutionsSearchResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionsSearchResponse institutionsSearchResponse = (InstitutionsSearchResponse)o;
        return Objects.equals(this.institutions, institutionsSearchResponse.institutions) && Objects.equals(this.requestId, institutionsSearchResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.institutions, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionsSearchResponse {\n");
        sb.append("    institutions: ").append(this.toIndentedString(this.institutions)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

