/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.Holding;
import com.plaid.client.model.InvestmentsAuthGetNumbers;
import com.plaid.client.model.InvestmentsAuthOwner;
import com.plaid.client.model.Item;
import com.plaid.client.model.Security;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="InvestmentsAuthGetResponse defines the response schema for `/investments/auth/get`")
public class InvestmentsAuthGetResponse {
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountBase> accounts = new ArrayList<AccountBase>();
    public static final String SERIALIZED_NAME_HOLDINGS = "holdings";
    @SerializedName(value="holdings")
    private List<Holding> holdings = new ArrayList<Holding>();
    public static final String SERIALIZED_NAME_SECURITIES = "securities";
    @SerializedName(value="securities")
    private List<Security> securities = new ArrayList<Security>();
    public static final String SERIALIZED_NAME_OWNERS = "owners";
    @SerializedName(value="owners")
    private List<InvestmentsAuthOwner> owners = new ArrayList<InvestmentsAuthOwner>();
    public static final String SERIALIZED_NAME_NUMBERS = "numbers";
    @SerializedName(value="numbers")
    private InvestmentsAuthGetNumbers numbers;
    public static final String SERIALIZED_NAME_ITEM = "item";
    @SerializedName(value="item")
    private Item item;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public InvestmentsAuthGetResponse accounts(List<AccountBase> accounts) {
        this.accounts = accounts;
        return this;
    }

    public InvestmentsAuthGetResponse addAccountsItem(AccountBase accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The accounts for which data is being retrieved")
    public List<AccountBase> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountBase> accounts) {
        this.accounts = accounts;
    }

    public InvestmentsAuthGetResponse holdings(List<Holding> holdings) {
        this.holdings = holdings;
        return this;
    }

    public InvestmentsAuthGetResponse addHoldingsItem(Holding holdingsItem) {
        this.holdings.add(holdingsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The holdings belonging to investment accounts associated with the Item. Details of the securities in the holdings are provided in the `securities` field. ")
    public List<Holding> getHoldings() {
        return this.holdings;
    }

    public void setHoldings(List<Holding> holdings) {
        this.holdings = holdings;
    }

    public InvestmentsAuthGetResponse securities(List<Security> securities) {
        this.securities = securities;
        return this;
    }

    public InvestmentsAuthGetResponse addSecuritiesItem(Security securitiesItem) {
        this.securities.add(securitiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Objects describing the securities held in the accounts associated with the Item. ")
    public List<Security> getSecurities() {
        return this.securities;
    }

    public void setSecurities(List<Security> securities) {
        this.securities = securities;
    }

    public InvestmentsAuthGetResponse owners(List<InvestmentsAuthOwner> owners) {
        this.owners = owners;
        return this;
    }

    public InvestmentsAuthGetResponse addOwnersItem(InvestmentsAuthOwner ownersItem) {
        this.owners.add(ownersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Information about the account owners for the accounts associated with the Item. ")
    public List<InvestmentsAuthOwner> getOwners() {
        return this.owners;
    }

    public void setOwners(List<InvestmentsAuthOwner> owners) {
        this.owners = owners;
    }

    public InvestmentsAuthGetResponse numbers(InvestmentsAuthGetNumbers numbers) {
        this.numbers = numbers;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public InvestmentsAuthGetNumbers getNumbers() {
        return this.numbers;
    }

    public void setNumbers(InvestmentsAuthGetNumbers numbers) {
        this.numbers = numbers;
    }

    public InvestmentsAuthGetResponse item(Item item) {
        this.item = item;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public InvestmentsAuthGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvestmentsAuthGetResponse investmentsAuthGetResponse = (InvestmentsAuthGetResponse)o;
        return Objects.equals(this.accounts, investmentsAuthGetResponse.accounts) && Objects.equals(this.holdings, investmentsAuthGetResponse.holdings) && Objects.equals(this.securities, investmentsAuthGetResponse.securities) && Objects.equals(this.owners, investmentsAuthGetResponse.owners) && Objects.equals(this.numbers, investmentsAuthGetResponse.numbers) && Objects.equals(this.item, investmentsAuthGetResponse.item) && Objects.equals(this.requestId, investmentsAuthGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.holdings, this.securities, this.owners, this.numbers, this.item, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvestmentsAuthGetResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    holdings: ").append(this.toIndentedString(this.holdings)).append("\n");
        sb.append("    securities: ").append(this.toIndentedString(this.securities)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    numbers: ").append(this.toIndentedString(this.numbers)).append("\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

