/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information on the ownership of an investments account")
public class InvestmentsAuthOwner {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_NAMES = "names";
    @SerializedName(value="names")
    private List<String> names = null;

    public InvestmentsAuthOwner accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the account that this identity information pertains to")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public InvestmentsAuthOwner names(List<String> names) {
        this.names = names;
        return this;
    }

    public InvestmentsAuthOwner addNamesItem(String namesItem) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.add(namesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of names associated with the account by the financial institution. In the case of a joint account, Plaid will make a best effort to report the names of all account holders.  If an Item contains multiple accounts with different owner names, some institutions will report all names associated with the Item in each account's `names` array.")
    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvestmentsAuthOwner investmentsAuthOwner = (InvestmentsAuthOwner)o;
        return Objects.equals(this.accountId, investmentsAuthOwner.accountId) && Objects.equals(this.names, investmentsAuthOwner.names);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.names);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvestmentsAuthOwner {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

