/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired after an asynchronous extraction on an investments account.")
public class InvestmentsHistoricalUpdateWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_NEW_INVESTMENTS_TRANSACTIONS = "new_investments_transactions";
    @SerializedName(value="new_investments_transactions")
    private Double newInvestmentsTransactions;
    public static final String SERIALIZED_NAME_CANCELED_INVESTMENTS_TRANSACTIONS = "canceled_investments_transactions";
    @SerializedName(value="canceled_investments_transactions")
    private Double canceledInvestmentsTransactions;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public InvestmentsHistoricalUpdateWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`INVESTMENTS_TRANSACTIONS`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public InvestmentsHistoricalUpdateWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`HISTORICAL_UPDATE`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public InvestmentsHistoricalUpdateWebhook itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public InvestmentsHistoricalUpdateWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public InvestmentsHistoricalUpdateWebhook newInvestmentsTransactions(Double newInvestmentsTransactions) {
        this.newInvestmentsTransactions = newInvestmentsTransactions;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of new transactions reported since the last time this webhook was fired.")
    public Double getNewInvestmentsTransactions() {
        return this.newInvestmentsTransactions;
    }

    public void setNewInvestmentsTransactions(Double newInvestmentsTransactions) {
        this.newInvestmentsTransactions = newInvestmentsTransactions;
    }

    public InvestmentsHistoricalUpdateWebhook canceledInvestmentsTransactions(Double canceledInvestmentsTransactions) {
        this.canceledInvestmentsTransactions = canceledInvestmentsTransactions;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of canceled transactions reported since the last time this webhook was fired.")
    public Double getCanceledInvestmentsTransactions() {
        return this.canceledInvestmentsTransactions;
    }

    public void setCanceledInvestmentsTransactions(Double canceledInvestmentsTransactions) {
        this.canceledInvestmentsTransactions = canceledInvestmentsTransactions;
    }

    public InvestmentsHistoricalUpdateWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvestmentsHistoricalUpdateWebhook investmentsHistoricalUpdateWebhook = (InvestmentsHistoricalUpdateWebhook)o;
        return Objects.equals(this.webhookType, investmentsHistoricalUpdateWebhook.webhookType) && Objects.equals(this.webhookCode, investmentsHistoricalUpdateWebhook.webhookCode) && Objects.equals(this.itemId, investmentsHistoricalUpdateWebhook.itemId) && Objects.equals(this.error, investmentsHistoricalUpdateWebhook.error) && Objects.equals(this.newInvestmentsTransactions, investmentsHistoricalUpdateWebhook.newInvestmentsTransactions) && Objects.equals(this.canceledInvestmentsTransactions, investmentsHistoricalUpdateWebhook.canceledInvestmentsTransactions) && Objects.equals((Object)this.environment, (Object)investmentsHistoricalUpdateWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.itemId, this.error, this.newInvestmentsTransactions, this.canceledInvestmentsTransactions, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvestmentsHistoricalUpdateWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    newInvestmentsTransactions: ").append(this.toIndentedString(this.newInvestmentsTransactions)).append("\n");
        sb.append("    canceledInvestmentsTransactions: ").append(this.toIndentedString(this.canceledInvestmentsTransactions)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

