/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.Holding;
import com.plaid.client.model.Item;
import com.plaid.client.model.Security;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="InvestmentsHoldingsGetResponse defines the response schema for `/investments/holdings/get`")
public class InvestmentsHoldingsGetResponse {
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountBase> accounts = new ArrayList<AccountBase>();
    public static final String SERIALIZED_NAME_HOLDINGS = "holdings";
    @SerializedName(value="holdings")
    private List<Holding> holdings = new ArrayList<Holding>();
    public static final String SERIALIZED_NAME_SECURITIES = "securities";
    @SerializedName(value="securities")
    private List<Security> securities = new ArrayList<Security>();
    public static final String SERIALIZED_NAME_ITEM = "item";
    @SerializedName(value="item")
    private Item item;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_IS_INVESTMENTS_FALLBACK_ITEM = "is_investments_fallback_item";
    @SerializedName(value="is_investments_fallback_item")
    private Boolean isInvestmentsFallbackItem;

    public InvestmentsHoldingsGetResponse accounts(List<AccountBase> accounts) {
        this.accounts = accounts;
        return this;
    }

    public InvestmentsHoldingsGetResponse addAccountsItem(AccountBase accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The accounts associated with the Item")
    public List<AccountBase> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountBase> accounts) {
        this.accounts = accounts;
    }

    public InvestmentsHoldingsGetResponse holdings(List<Holding> holdings) {
        this.holdings = holdings;
        return this;
    }

    public InvestmentsHoldingsGetResponse addHoldingsItem(Holding holdingsItem) {
        this.holdings.add(holdingsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The holdings belonging to investment accounts associated with the Item. Details of the securities in the holdings are provided in the `securities` field. ")
    public List<Holding> getHoldings() {
        return this.holdings;
    }

    public void setHoldings(List<Holding> holdings) {
        this.holdings = holdings;
    }

    public InvestmentsHoldingsGetResponse securities(List<Security> securities) {
        this.securities = securities;
        return this;
    }

    public InvestmentsHoldingsGetResponse addSecuritiesItem(Security securitiesItem) {
        this.securities.add(securitiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Objects describing the securities held in the accounts associated with the Item. ")
    public List<Security> getSecurities() {
        return this.securities;
    }

    public void setSecurities(List<Security> securities) {
        this.securities = securities;
    }

    public InvestmentsHoldingsGetResponse item(Item item) {
        this.item = item;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public InvestmentsHoldingsGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public InvestmentsHoldingsGetResponse isInvestmentsFallbackItem(Boolean isInvestmentsFallbackItem) {
        this.isInvestmentsFallbackItem = isInvestmentsFallbackItem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When true, this field indicates that the Item's portfolio was manually created with the Investments Fallback flow.")
    public Boolean getIsInvestmentsFallbackItem() {
        return this.isInvestmentsFallbackItem;
    }

    public void setIsInvestmentsFallbackItem(Boolean isInvestmentsFallbackItem) {
        this.isInvestmentsFallbackItem = isInvestmentsFallbackItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvestmentsHoldingsGetResponse investmentsHoldingsGetResponse = (InvestmentsHoldingsGetResponse)o;
        return Objects.equals(this.accounts, investmentsHoldingsGetResponse.accounts) && Objects.equals(this.holdings, investmentsHoldingsGetResponse.holdings) && Objects.equals(this.securities, investmentsHoldingsGetResponse.securities) && Objects.equals(this.item, investmentsHoldingsGetResponse.item) && Objects.equals(this.requestId, investmentsHoldingsGetResponse.requestId) && Objects.equals(this.isInvestmentsFallbackItem, investmentsHoldingsGetResponse.isInvestmentsFallbackItem);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.holdings, this.securities, this.item, this.requestId, this.isInvestmentsFallbackItem);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvestmentsHoldingsGetResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    holdings: ").append(this.toIndentedString(this.holdings)).append("\n");
        sb.append("    securities: ").append(this.toIndentedString(this.securities)).append("\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    isInvestmentsFallbackItem: ").append(this.toIndentedString(this.isInvestmentsFallbackItem)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

