/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An optional object to filter `/investments/transactions/get` results. If provided, must be non-`null`.")
public class InvestmentsTransactionsGetRequestOptions {
    public static final String SERIALIZED_NAME_ACCOUNT_IDS = "account_ids";
    @SerializedName(value="account_ids")
    private List<String> accountIds = null;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 100;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private Integer offset = 0;
    public static final String SERIALIZED_NAME_ASYNC_UPDATE = "async_update";
    @SerializedName(value="async_update")
    private Boolean asyncUpdate = false;

    public InvestmentsTransactionsGetRequestOptions accountIds(List<String> accountIds) {
        this.accountIds = accountIds;
        return this;
    }

    public InvestmentsTransactionsGetRequestOptions addAccountIdsItem(String accountIdsItem) {
        if (this.accountIds == null) {
            this.accountIds = new ArrayList<String>();
        }
        this.accountIds.add(accountIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of `account_ids` to retrieve for the Item.")
    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(List<String> accountIds) {
        this.accountIds = accountIds;
    }

    public InvestmentsTransactionsGetRequestOptions count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of transactions to fetch. ")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public InvestmentsTransactionsGetRequestOptions offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of transactions to skip when fetching transaction history")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public InvestmentsTransactionsGetRequestOptions asyncUpdate(Boolean asyncUpdate) {
        this.asyncUpdate = asyncUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the Item was not initialized with the investments product via the `products` array when calling `/link/token/create`, and `async_update` is set to true, the initial Investments extraction will happen asynchronously. Plaid will subsequently fire a `HISTORICAL_UPDATE` webhook when the extraction completes. When `false`, Plaid will wait to return a response until extraction completion and no `HISTORICAL_UPDATE` webhook will fire. Note that while the extraction is happening asynchronously, calls to `/investments/transactions/get` and `/investments/refresh` will return `PRODUCT_NOT_READY` errors until the extraction completes.")
    public Boolean getAsyncUpdate() {
        return this.asyncUpdate;
    }

    public void setAsyncUpdate(Boolean asyncUpdate) {
        this.asyncUpdate = asyncUpdate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvestmentsTransactionsGetRequestOptions investmentsTransactionsGetRequestOptions = (InvestmentsTransactionsGetRequestOptions)o;
        return Objects.equals(this.accountIds, investmentsTransactionsGetRequestOptions.accountIds) && Objects.equals(this.count, investmentsTransactionsGetRequestOptions.count) && Objects.equals(this.offset, investmentsTransactionsGetRequestOptions.offset) && Objects.equals(this.asyncUpdate, investmentsTransactionsGetRequestOptions.asyncUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.accountIds, this.count, this.offset, this.asyncUpdate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvestmentsTransactionsGetRequestOptions {\n");
        sb.append("    accountIds: ").append(this.toIndentedString(this.accountIds)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    asyncUpdate: ").append(this.toIndentedString(this.asyncUpdate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

