/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.InvestmentTransaction;
import com.plaid.client.model.Item;
import com.plaid.client.model.Security;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="InvestmentsTransactionsGetResponse defines the response schema for `/investments/transactions/get`")
public class InvestmentsTransactionsGetResponse {
    public static final String SERIALIZED_NAME_ITEM = "item";
    @SerializedName(value="item")
    private Item item;
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountBase> accounts = new ArrayList<AccountBase>();
    public static final String SERIALIZED_NAME_SECURITIES = "securities";
    @SerializedName(value="securities")
    private List<Security> securities = new ArrayList<Security>();
    public static final String SERIALIZED_NAME_INVESTMENT_TRANSACTIONS = "investment_transactions";
    @SerializedName(value="investment_transactions")
    private List<InvestmentTransaction> investmentTransactions = new ArrayList<InvestmentTransaction>();
    public static final String SERIALIZED_NAME_TOTAL_INVESTMENT_TRANSACTIONS = "total_investment_transactions";
    @SerializedName(value="total_investment_transactions")
    private Integer totalInvestmentTransactions;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_IS_INVESTMENTS_FALLBACK_ITEM = "is_investments_fallback_item";
    @SerializedName(value="is_investments_fallback_item")
    private Boolean isInvestmentsFallbackItem;

    public InvestmentsTransactionsGetResponse item(Item item) {
        this.item = item;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public InvestmentsTransactionsGetResponse accounts(List<AccountBase> accounts) {
        this.accounts = accounts;
        return this;
    }

    public InvestmentsTransactionsGetResponse addAccountsItem(AccountBase accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The accounts for which transaction history is being fetched.")
    public List<AccountBase> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountBase> accounts) {
        this.accounts = accounts;
    }

    public InvestmentsTransactionsGetResponse securities(List<Security> securities) {
        this.securities = securities;
        return this;
    }

    public InvestmentsTransactionsGetResponse addSecuritiesItem(Security securitiesItem) {
        this.securities.add(securitiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="All securities for which there is a corresponding transaction being fetched.")
    public List<Security> getSecurities() {
        return this.securities;
    }

    public void setSecurities(List<Security> securities) {
        this.securities = securities;
    }

    public InvestmentsTransactionsGetResponse investmentTransactions(List<InvestmentTransaction> investmentTransactions) {
        this.investmentTransactions = investmentTransactions;
        return this;
    }

    public InvestmentsTransactionsGetResponse addInvestmentTransactionsItem(InvestmentTransaction investmentTransactionsItem) {
        this.investmentTransactions.add(investmentTransactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The transactions being fetched")
    public List<InvestmentTransaction> getInvestmentTransactions() {
        return this.investmentTransactions;
    }

    public void setInvestmentTransactions(List<InvestmentTransaction> investmentTransactions) {
        this.investmentTransactions = investmentTransactions;
    }

    public InvestmentsTransactionsGetResponse totalInvestmentTransactions(Integer totalInvestmentTransactions) {
        this.totalInvestmentTransactions = totalInvestmentTransactions;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of transactions available within the date range specified. If `total_investment_transactions` is larger than the size of the `transactions` array, more transactions are available and can be fetched via manipulating the `offset` parameter.")
    public Integer getTotalInvestmentTransactions() {
        return this.totalInvestmentTransactions;
    }

    public void setTotalInvestmentTransactions(Integer totalInvestmentTransactions) {
        this.totalInvestmentTransactions = totalInvestmentTransactions;
    }

    public InvestmentsTransactionsGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public InvestmentsTransactionsGetResponse isInvestmentsFallbackItem(Boolean isInvestmentsFallbackItem) {
        this.isInvestmentsFallbackItem = isInvestmentsFallbackItem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When true, this field indicates that the Item's portfolio was manually created with the Investments Fallback flow.")
    public Boolean getIsInvestmentsFallbackItem() {
        return this.isInvestmentsFallbackItem;
    }

    public void setIsInvestmentsFallbackItem(Boolean isInvestmentsFallbackItem) {
        this.isInvestmentsFallbackItem = isInvestmentsFallbackItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvestmentsTransactionsGetResponse investmentsTransactionsGetResponse = (InvestmentsTransactionsGetResponse)o;
        return Objects.equals(this.item, investmentsTransactionsGetResponse.item) && Objects.equals(this.accounts, investmentsTransactionsGetResponse.accounts) && Objects.equals(this.securities, investmentsTransactionsGetResponse.securities) && Objects.equals(this.investmentTransactions, investmentsTransactionsGetResponse.investmentTransactions) && Objects.equals(this.totalInvestmentTransactions, investmentsTransactionsGetResponse.totalInvestmentTransactions) && Objects.equals(this.requestId, investmentsTransactionsGetResponse.requestId) && Objects.equals(this.isInvestmentsFallbackItem, investmentsTransactionsGetResponse.isInvestmentsFallbackItem);
    }

    public int hashCode() {
        return Objects.hash(this.item, this.accounts, this.securities, this.investmentTransactions, this.totalInvestmentTransactions, this.requestId, this.isInvestmentsFallbackItem);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvestmentsTransactionsGetResponse {\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    securities: ").append(this.toIndentedString(this.securities)).append("\n");
        sb.append("    investmentTransactions: ").append(this.toIndentedString(this.investmentTransactions)).append("\n");
        sb.append("    totalInvestmentTransactions: ").append(this.toIndentedString(this.totalInvestmentTransactions)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    isInvestmentsFallbackItem: ").append(this.toIndentedString(this.isInvestmentsFallbackItem)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

