/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SecurityOverride;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specify the list of investments transactions on the account.")
public class InvestmentsTransactionsOverride {
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Double quantity;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    private Double price;
    public static final String SERIALIZED_NAME_FEES = "fees";
    @SerializedName(value="fees")
    private Double fees;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_SECURITY = "security";
    @SerializedName(value="security")
    private SecurityOverride security;

    public InvestmentsTransactionsOverride date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="Posting date for the transaction. Must be formatted as an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) date.")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public InvestmentsTransactionsOverride name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The institution's description of the transaction.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InvestmentsTransactionsOverride quantity(Double quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of units of the security involved in this transaction. Must be positive if the type is a buy and negative if the type is a sell.")
    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public InvestmentsTransactionsOverride price(Double price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(required=true, value="The price of the security at which this transaction occurred.")
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public InvestmentsTransactionsOverride fees(Double fees) {
        this.fees = fees;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The combined value of all fees applied to this transaction.")
    public Double getFees() {
        return this.fees;
    }

    public void setFees(Double fees) {
        this.fees = fees;
    }

    public InvestmentsTransactionsOverride type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the investment transaction. Possible values are: `buy`: Buying an investment `sell`: Selling an investment `cash`: Activity that modifies a cash position `fee`: A fee on the account `transfer`: Activity that modifies a position, but not through buy/sell activity e.g. options exercise, portfolio transfer")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public InvestmentsTransactionsOverride currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="Either a valid `iso_currency_code` or `unofficial_currency_code`")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public InvestmentsTransactionsOverride security(SecurityOverride security) {
        this.security = security;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SecurityOverride getSecurity() {
        return this.security;
    }

    public void setSecurity(SecurityOverride security) {
        this.security = security;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvestmentsTransactionsOverride investmentsTransactionsOverride = (InvestmentsTransactionsOverride)o;
        return Objects.equals(this.date, investmentsTransactionsOverride.date) && Objects.equals(this.name, investmentsTransactionsOverride.name) && Objects.equals(this.quantity, investmentsTransactionsOverride.quantity) && Objects.equals(this.price, investmentsTransactionsOverride.price) && Objects.equals(this.fees, investmentsTransactionsOverride.fees) && Objects.equals(this.type, investmentsTransactionsOverride.type) && Objects.equals(this.currency, investmentsTransactionsOverride.currency) && Objects.equals(this.security, investmentsTransactionsOverride.security);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.name, this.quantity, this.price, this.fees, this.type, this.currency, this.security);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvestmentsTransactionsOverride {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    security: ").append(this.toIndentedString(this.security)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

