/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.Products;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata about the Item.")
public class Item {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_AVAILABLE_PRODUCTS = "available_products";
    @SerializedName(value="available_products")
    private List<Products> availableProducts = new ArrayList<Products>();
    public static final String SERIALIZED_NAME_BILLED_PRODUCTS = "billed_products";
    @SerializedName(value="billed_products")
    private List<Products> billedProducts = new ArrayList<Products>();
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<Products> products = null;
    public static final String SERIALIZED_NAME_CONSENTED_PRODUCTS = "consented_products";
    @SerializedName(value="consented_products")
    private List<Products> consentedProducts = null;
    public static final String SERIALIZED_NAME_CONSENT_EXPIRATION_TIME = "consent_expiration_time";
    @SerializedName(value="consent_expiration_time")
    private OffsetDateTime consentExpirationTime;
    public static final String SERIALIZED_NAME_UPDATE_TYPE = "update_type";
    @SerializedName(value="update_type")
    private UpdateTypeEnum updateType;

    public Item itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid Item ID. The `item_id` is always unique; linking the same account at the same institution twice will result in two Items with different `item_id` values. Like all Plaid identifiers, the `item_id` is case-sensitive.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public Item institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid Institution ID associated with the Item. Field is `null` for Items created via Same Day Micro-deposits.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public Item webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The URL registered to receive webhooks for the Item.")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public Item error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public Item availableProducts(List<Products> availableProducts) {
        this.availableProducts = availableProducts;
        return this;
    }

    public Item addAvailableProductsItem(Products availableProductsItem) {
        this.availableProducts.add(availableProductsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of products available for the Item that have not yet been accessed. The contents of this array will be mutually exclusive with `billed_products`.")
    public List<Products> getAvailableProducts() {
        return this.availableProducts;
    }

    public void setAvailableProducts(List<Products> availableProducts) {
        this.availableProducts = availableProducts;
    }

    public Item billedProducts(List<Products> billedProducts) {
        this.billedProducts = billedProducts;
        return this;
    }

    public Item addBilledProductsItem(Products billedProductsItem) {
        this.billedProducts.add(billedProductsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of products that have been billed for the Item. The contents of this array will be mutually exclusive with `available_products`. Note - `billed_products` is populated in all environments but only requests in Production are billed. Also note that products that are billed on a pay-per-call basis rather than a pay-per-Item basis, such as `balance`, will not appear here. ")
    public List<Products> getBilledProducts() {
        return this.billedProducts;
    }

    public void setBilledProducts(List<Products> billedProducts) {
        this.billedProducts = billedProducts;
    }

    public Item products(List<Products> products) {
        this.products = products;
        return this;
    }

    public Item addProductsItem(Products productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<Products>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of products added to the Item. In almost all cases, this will be the same as the `billed_products` field. For some products, it is possible for the product to be added to an Item but not yet billed (e.g. Assets, before `/asset_report/create` has been called, or Auth or Identity when added as Optional Products but before their endpoints have been called), in which case the product may appear in `products` but not in `billed_products`. ")
    public List<Products> getProducts() {
        return this.products;
    }

    public void setProducts(List<Products> products) {
        this.products = products;
    }

    public Item consentedProducts(List<Products> consentedProducts) {
        this.consentedProducts = consentedProducts;
        return this;
    }

    public Item addConsentedProductsItem(Products consentedProductsItem) {
        if (this.consentedProducts == null) {
            this.consentedProducts = new ArrayList<Products>();
        }
        this.consentedProducts.add(consentedProductsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of products that have gone through consent collection for the Item. If the session is not enrolled in [Data Transparency Messaging](/docs/link/data-transparency-messaging-migration-guide), this field is not used. ")
    public List<Products> getConsentedProducts() {
        return this.consentedProducts;
    }

    public void setConsentedProducts(List<Products> consentedProducts) {
        this.consentedProducts = consentedProducts;
    }

    public Item consentExpirationTime(OffsetDateTime consentExpirationTime) {
        this.consentExpirationTime = consentExpirationTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The RFC 3339 timestamp after which the consent provided by the end user will expire. Upon consent expiration, the item will enter the `ITEM_LOGIN_REQUIRED` error state. To circumvent the `ITEM_LOGIN_REQUIRED` error and maintain continuous consent, the end user can reauthenticate via Link\u2019s update mode in advance of the consent expiration time.  Note - This is only relevant for certain OAuth-based institutions. For all other institutions, this field will be null. ")
    public OffsetDateTime getConsentExpirationTime() {
        return this.consentExpirationTime;
    }

    public void setConsentExpirationTime(OffsetDateTime consentExpirationTime) {
        this.consentExpirationTime = consentExpirationTime;
    }

    public Item updateType(UpdateTypeEnum updateType) {
        this.updateType = updateType;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether an Item requires user interaction to be updated, which can be the case for Items with some forms of two-factor authentication.  `background` - Item can be updated in the background  `user_present_required` - Item requires user interaction to be updated")
    public UpdateTypeEnum getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(UpdateTypeEnum updateType) {
        this.updateType = updateType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.itemId, item.itemId) && Objects.equals(this.institutionId, item.institutionId) && Objects.equals(this.webhook, item.webhook) && Objects.equals(this.error, item.error) && Objects.equals(this.availableProducts, item.availableProducts) && Objects.equals(this.billedProducts, item.billedProducts) && Objects.equals(this.products, item.products) && Objects.equals(this.consentedProducts, item.consentedProducts) && Objects.equals(this.consentExpirationTime, item.consentExpirationTime) && Objects.equals((Object)this.updateType, (Object)item.updateType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.itemId, this.institutionId, this.webhook, this.error, this.availableProducts, this.billedProducts, this.products, this.consentedProducts, this.consentExpirationTime, this.updateType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    availableProducts: ").append(this.toIndentedString(this.availableProducts)).append("\n");
        sb.append("    billedProducts: ").append(this.toIndentedString(this.billedProducts)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    consentedProducts: ").append(this.toIndentedString(this.consentedProducts)).append("\n");
        sb.append("    consentExpirationTime: ").append(this.toIndentedString(this.consentExpirationTime)).append("\n");
        sb.append("    updateType: ").append(this.toIndentedString((Object)this.updateType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UpdateTypeEnum {
        BACKGROUND("background"),
        USER_PRESENT_REQUIRED("user_present_required");

        private String value;

        private UpdateTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UpdateTypeEnum fromValue(String value) {
            for (UpdateTypeEnum b : UpdateTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<UpdateTypeEnum> {
            public void write(JsonWriter jsonWriter, UpdateTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public UpdateTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UpdateTypeEnum.fromValue(value);
            }
        }
    }
}

