/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Activity;
import com.plaid.client.model.LastDataAccessTimes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes a historical log of user consent events.")
public class ItemActivityListResponse {
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_ACTIVITIES = "activities";
    @SerializedName(value="activities")
    private List<Activity> activities = new ArrayList<Activity>();
    public static final String SERIALIZED_NAME_LAST_DATA_ACCESS_TIMES = "last_data_access_times";
    @SerializedName(value="last_data_access_times")
    private List<LastDataAccessTimes> lastDataAccessTimes = new ArrayList<LastDataAccessTimes>();
    public static final String SERIALIZED_NAME_CURSOR = "cursor";
    @SerializedName(value="cursor")
    private String cursor;

    public ItemActivityListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public ItemActivityListResponse activities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    public ItemActivityListResponse addActivitiesItem(Activity activitiesItem) {
        this.activities.add(activitiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of activities.")
    public List<Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<Activity> activities) {
        this.activities = activities;
    }

    public ItemActivityListResponse lastDataAccessTimes(List<LastDataAccessTimes> lastDataAccessTimes) {
        this.lastDataAccessTimes = lastDataAccessTimes;
        return this;
    }

    public ItemActivityListResponse addLastDataAccessTimesItem(LastDataAccessTimes lastDataAccessTimesItem) {
        this.lastDataAccessTimes.add(lastDataAccessTimesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of objects containing timestamps for the last time each data type was accessed per application.")
    public List<LastDataAccessTimes> getLastDataAccessTimes() {
        return this.lastDataAccessTimes;
    }

    public void setLastDataAccessTimes(List<LastDataAccessTimes> lastDataAccessTimes) {
        this.lastDataAccessTimes = lastDataAccessTimes;
    }

    public ItemActivityListResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cursor used for pagination.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemActivityListResponse itemActivityListResponse = (ItemActivityListResponse)o;
        return Objects.equals(this.requestId, itemActivityListResponse.requestId) && Objects.equals(this.activities, itemActivityListResponse.activities) && Objects.equals(this.lastDataAccessTimes, itemActivityListResponse.lastDataAccessTimes) && Objects.equals(this.cursor, itemActivityListResponse.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.activities, this.lastDataAccessTimes, this.cursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemActivityListResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("    lastDataAccessTimes: ").append(this.toIndentedString(this.lastDataAccessTimes)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

