/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when a user successfully adds a Plaid item during a Link session. Contains the public token for the item.")
public class ItemAddResultWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_LINK_SESSION_ID = "link_session_id";
    @SerializedName(value="link_session_id")
    private String linkSessionId;
    public static final String SERIALIZED_NAME_LINK_TOKEN = "link_token";
    @SerializedName(value="link_token")
    private String linkToken;
    public static final String SERIALIZED_NAME_PUBLIC_TOKEN = "public_token";
    @SerializedName(value="public_token")
    private String publicToken;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public ItemAddResultWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`LINK`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public ItemAddResultWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`ITEM_ADD_RESULT`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public ItemAddResultWebhook linkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier for the Link session.")
    public String getLinkSessionId() {
        return this.linkSessionId;
    }

    public void setLinkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
    }

    public ItemAddResultWebhook linkToken(String linkToken) {
        this.linkToken = linkToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The link token used to create the Link session.")
    public String getLinkToken() {
        return this.linkToken;
    }

    public void setLinkToken(String linkToken) {
        this.linkToken = linkToken;
    }

    public ItemAddResultWebhook publicToken(String publicToken) {
        this.publicToken = publicToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The public token corresponding to the item that was added.")
    public String getPublicToken() {
        return this.publicToken;
    }

    public void setPublicToken(String publicToken) {
        this.publicToken = publicToken;
    }

    public ItemAddResultWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemAddResultWebhook itemAddResultWebhook = (ItemAddResultWebhook)o;
        return Objects.equals(this.webhookType, itemAddResultWebhook.webhookType) && Objects.equals(this.webhookCode, itemAddResultWebhook.webhookCode) && Objects.equals(this.linkSessionId, itemAddResultWebhook.linkSessionId) && Objects.equals(this.linkToken, itemAddResultWebhook.linkToken) && Objects.equals(this.publicToken, itemAddResultWebhook.publicToken) && Objects.equals((Object)this.environment, (Object)itemAddResultWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.linkSessionId, this.linkToken, this.publicToken, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemAddResultWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    linkSessionId: ").append(this.toIndentedString(this.linkSessionId)).append("\n");
        sb.append("    linkToken: ").append(this.toIndentedString(this.linkToken)).append("\n");
        sb.append("    publicToken: ").append(this.toIndentedString(this.publicToken)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

