/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ConnectedApplication;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes the connected application for a particular end user.")
public class ItemApplicationListResponse {
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_APPLICATIONS = "applications";
    @SerializedName(value="applications")
    private List<ConnectedApplication> applications = new ArrayList<ConnectedApplication>();

    public ItemApplicationListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public ItemApplicationListResponse applications(List<ConnectedApplication> applications) {
        this.applications = applications;
        return this;
    }

    public ItemApplicationListResponse addApplicationsItem(ConnectedApplication applicationsItem) {
        this.applications.add(applicationsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of connected applications.")
    public List<ConnectedApplication> getApplications() {
        return this.applications;
    }

    public void setApplications(List<ConnectedApplication> applications) {
        this.applications = applications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemApplicationListResponse itemApplicationListResponse = (ItemApplicationListResponse)o;
        return Objects.equals(this.requestId, itemApplicationListResponse.requestId) && Objects.equals(this.applications, itemApplicationListResponse.applications);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.applications);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemApplicationListResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    applications: ").append(this.toIndentedString(this.applications)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

