/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="User authentication parameters, for clients making a request without an `access_token`. This is only allowed for select clients and will not be supported in the future. Most clients should call /item/import to obtain an access token before making a request.")
public class ItemApplicationListUserAuth {
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_FI_USERNAME_HASH = "fi_username_hash";
    @SerializedName(value="fi_username_hash")
    private String fiUsernameHash;

    public ItemApplicationListUserAuth userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Account username.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ItemApplicationListUserAuth fiUsernameHash(String fiUsernameHash) {
        this.fiUsernameHash = fiUsernameHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Account username hashed by FI.")
    public String getFiUsernameHash() {
        return this.fiUsernameHash;
    }

    public void setFiUsernameHash(String fiUsernameHash) {
        this.fiUsernameHash = fiUsernameHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemApplicationListUserAuth itemApplicationListUserAuth = (ItemApplicationListUserAuth)o;
        return Objects.equals(this.userId, itemApplicationListUserAuth.userId) && Objects.equals(this.fiUsernameHash, itemApplicationListUserAuth.fiUsernameHash);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.fiUsernameHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemApplicationListUserAuth {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    fiUsernameHash: ").append(this.toIndentedString(this.fiUsernameHash)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

