/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Scopes;
import com.plaid.client.model.ScopesContext;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ItemApplicationScopesUpdateRequest defines the request schema for `/item/application/scopes/update`")
public class ItemApplicationScopesUpdateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_APPLICATION_ID = "application_id";
    @SerializedName(value="application_id")
    private String applicationId;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private Scopes scopes;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private String state;
    public static final String SERIALIZED_NAME_CONTEXT = "context";
    @SerializedName(value="context")
    private ScopesContext context;

    public ItemApplicationScopesUpdateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ItemApplicationScopesUpdateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ItemApplicationScopesUpdateRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public ItemApplicationScopesUpdateRequest applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(required=true, value="This field will map to the application ID that is returned from /item/application/list, or provided to the institution in an oauth redirect.")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ItemApplicationScopesUpdateRequest scopes(Scopes scopes) {
        this.scopes = scopes;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Scopes getScopes() {
        return this.scopes;
    }

    public void setScopes(Scopes scopes) {
        this.scopes = scopes;
    }

    public ItemApplicationScopesUpdateRequest state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When scopes are updated during enrollment, this field must be populated with the state sent to the partner in the OAuth Login URI. This field is required when the context is `ENROLLMENT`.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ItemApplicationScopesUpdateRequest context(ScopesContext context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ScopesContext getContext() {
        return this.context;
    }

    public void setContext(ScopesContext context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemApplicationScopesUpdateRequest itemApplicationScopesUpdateRequest = (ItemApplicationScopesUpdateRequest)o;
        return Objects.equals(this.clientId, itemApplicationScopesUpdateRequest.clientId) && Objects.equals(this.secret, itemApplicationScopesUpdateRequest.secret) && Objects.equals(this.accessToken, itemApplicationScopesUpdateRequest.accessToken) && Objects.equals(this.applicationId, itemApplicationScopesUpdateRequest.applicationId) && Objects.equals(this.scopes, itemApplicationScopesUpdateRequest.scopes) && Objects.equals(this.state, itemApplicationScopesUpdateRequest.state) && Objects.equals((Object)this.context, (Object)itemApplicationScopesUpdateRequest.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.accessToken, this.applicationId, this.scopes, this.state, this.context});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemApplicationScopesUpdateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    context: ").append(this.toIndentedString((Object)this.context)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

