/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ItemImportRequestOptions;
import com.plaid.client.model.ItemImportRequestUserAuth;
import com.plaid.client.model.Products;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ItemImportRequest defines the request schema for `/item/import`")
public class ItemImportRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<Products> products = new ArrayList<Products>();
    public static final String SERIALIZED_NAME_USER_AUTH = "user_auth";
    @SerializedName(value="user_auth")
    private ItemImportRequestUserAuth userAuth;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private ItemImportRequestOptions options;

    public ItemImportRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ItemImportRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ItemImportRequest products(List<Products> products) {
        this.products = products;
        return this;
    }

    public ItemImportRequest addProductsItem(Products productsItem) {
        this.products.add(productsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of product strings")
    public List<Products> getProducts() {
        return this.products;
    }

    public void setProducts(List<Products> products) {
        this.products = products;
    }

    public ItemImportRequest userAuth(ItemImportRequestUserAuth userAuth) {
        this.userAuth = userAuth;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ItemImportRequestUserAuth getUserAuth() {
        return this.userAuth;
    }

    public void setUserAuth(ItemImportRequestUserAuth userAuth) {
        this.userAuth = userAuth;
    }

    public ItemImportRequest options(ItemImportRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ItemImportRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(ItemImportRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemImportRequest itemImportRequest = (ItemImportRequest)o;
        return Objects.equals(this.clientId, itemImportRequest.clientId) && Objects.equals(this.secret, itemImportRequest.secret) && Objects.equals(this.products, itemImportRequest.products) && Objects.equals(this.userAuth, itemImportRequest.userAuth) && Objects.equals(this.options, itemImportRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.products, this.userAuth, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemImportRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    userAuth: ").append(this.toIndentedString(this.userAuth)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

