/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Object of user ID and auth token pair, permitting Plaid to aggregate a user\u2019s accounts")
public class ItemImportRequestUserAuth {
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_AUTH_TOKEN = "auth_token";
    @SerializedName(value="auth_token")
    private String authToken;

    public ItemImportRequestUserAuth userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(required=true, value="Opaque user identifier")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ItemImportRequestUserAuth authToken(String authToken) {
        this.authToken = authToken;
        return this;
    }

    @ApiModelProperty(required=true, value="Authorization token Plaid will use to aggregate this user\u2019s accounts")
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemImportRequestUserAuth itemImportRequestUserAuth = (ItemImportRequestUserAuth)o;
        return Objects.equals(this.userId, itemImportRequestUserAuth.userId) && Objects.equals(this.authToken, itemImportRequestUserAuth.authToken);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.authToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemImportRequestUserAuth {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    authToken: ").append(this.toIndentedString(this.authToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

